/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.gossip.model.render;

import jline.ANSIBuffer;
import jline.Terminal;
import org.codehaus.mojo.groovy.gossip.Event;
import org.codehaus.mojo.groovy.gossip.model.render.Renderer;

public class ColorRenderer
extends Renderer {
    private boolean truncate = false;
    private int maxLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColorRenderer() {
        Terminal term = Terminal.getTerminal();
        int w = term.getTerminalWidth();
        this.maxLength = w < 1 ? 79 : w - 1;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean flag) {
        this.truncate = flag;
    }

    public void setTruncate(String flag) {
        this.setTruncate(Boolean.valueOf(flag));
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public void setMaxLength(String length) {
        if (!$assertionsDisabled && length == null) {
            throw new AssertionError();
        }
        this.setMaxLength(Integer.parseInt(length));
    }

    public String render(Event event) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        ANSIBuffer buff = new ANSIBuffer();
        buff.append("[");
        switch (event.level.id) {
            case 0: 
            case 10: {
                buff.yellow(event.level.label);
                break;
            }
            case 20: {
                buff.green(event.level.label);
                break;
            }
            case 30: 
            case 40: {
                buff.red(event.level.label);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        buff.append("]");
        switch (event.level.id) {
            case 20: 
            case 30: {
                buff.append(" ");
            }
        }
        buff.append(" ");
        buff.append(event.logger.getName());
        buff.append(" - ");
        buff.append(event.message);
        buff.append(NEWLINE);
        if (event.cause != null) {
            buff.append(event.toString());
            StackTraceElement[] trace = event.cause.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                buff.append(trace[i].toString());
            }
        }
        if (this.truncate && buff.getPlainBuffer().length() > this.maxLength) {
            return buff.toString().substring(0, this.maxLength - 4) + " ..." + NEWLINE;
        }
        return buff.toString();
    }

    static {
        $assertionsDisabled = !ColorRenderer.class.desiredAssertionStatus();
    }
}

