/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy.gossip.model.source;

import java.net.URL;
import org.codehaus.mojo.groovy.gossip.config.ConfigurationException;
import org.codehaus.mojo.groovy.gossip.model.Configuration;
import org.codehaus.mojo.groovy.gossip.model.Source;

public class ResourceSource
extends Source {
    private String name;
    private ClassLoader classLoader;

    public ResourceSource() {
    }

    public ResourceSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Configuration load() throws Exception {
        URL url;
        if (this.name == null) {
            throw new ConfigurationException("Missing property: name");
        }
        Configuration config = null;
        ClassLoader cl = this.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((url = cl.getResource(this.name)) == null) {
            this.log.debug("Unable to load; missing resource: {}", this.name);
        } else {
            config = this.load(url);
        }
        return config;
    }
}

