/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.linker;

import java.io.File;
import java.util.List;
import org.codehaus.mojo.natives.linker.AbstractLinker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.util.cli.Commandline;

public class ArchiveLinker
extends AbstractLinker {
    public static final String EXECUTABLE = "ar";

    protected Commandline createLinkerCommandLine(List objectFiles, LinkerConfiguration config) {
        int i;
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = EXECUTABLE;
        if (config.getExecutable() != null && config.getExecutable().trim().length() != 0) {
            executable = config.getExecutable();
        }
        cl.setExecutable(executable);
        for (i = 0; i < config.getStartOptions().length; ++i) {
            cl.createArg().setValue(config.getStartOptions()[i]);
        }
        cl.createArg().setFile(config.getOutputFile());
        for (i = 0; i < objectFiles.size(); ++i) {
            File objFile = (File)objectFiles.get(i);
            cl.createArg().setValue(objFile.getPath());
        }
        return cl;
    }
}

