/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.bcc;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.c.CLinker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class BCCLinker
extends CLinker {
    public static final String DEFAULT_EXECUTABLE = "ilink32";

    protected Commandline createLinkerCommandLine(List objectFiles, LinkerConfiguration config) throws NativeBuildException {
        String fileName;
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = DEFAULT_EXECUTABLE;
        if (config.getExecutable() != null && config.getExecutable().trim().length() != 0) {
            executable = config.getExecutable();
        }
        cl.createArg().setValue(executable);
        cl.addArguments(config.getStartOptions());
        for (int i = 0; i < objectFiles.size(); ++i) {
            File objFile = (File)objectFiles.get(i);
            cl.createArg().setValue(objFile.getPath());
        }
        Iterator iter = config.getExternalLibFileNames().iterator();
        while (iter.hasNext()) {
            fileName = (String)iter.next();
            if (FileUtils.getExtension((String)fileName).toLowerCase().equals("res")) continue;
            cl.createArg().setFile(new File(config.getExternalLibDirectory(), fileName));
        }
        cl.createArg().setValue("," + config.getOutputFile());
        cl.createArg().setValue(",");
        cl.addArguments(config.getMiddleOptions());
        cl.createArg().setValue(",");
        iter = config.getExternalLibFileNames().iterator();
        while (iter.hasNext()) {
            fileName = (String)iter.next();
            if (!FileUtils.getExtension((String)fileName).toLowerCase().equals("res")) continue;
            cl.createArg().setFile(new File(config.getExternalLibDirectory(), fileName));
        }
        return cl;
    }
}

