/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import java.io.File;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.AbstractMessageCompiler;
import org.codehaus.mojo.natives.compiler.MessageCompilerConfiguration;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.util.cli.Commandline;

public class MSVCMessageCompiler
extends AbstractMessageCompiler {
    protected Commandline getCommandLine(MessageCompilerConfiguration config, File source) throws NativeBuildException {
        Commandline cl = new Commandline();
        EnvUtil.setupCommandlineEnv((Commandline)cl, (EnvFactory)config.getEnvFactory());
        if (config.getWorkingDirectory() != null) {
            cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        }
        if (config.getExecutable() == null || config.getExecutable().trim().length() == 0) {
            config.setExecutable("mc.exe");
        }
        cl.setExecutable(config.getExecutable().trim());
        cl.addArguments(config.getOptions());
        if (config.getOutputDirectory() != null && config.getOutputDirectory().getPath().trim().length() != 0) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(config.getOutputDirectory().getPath());
            cl.createArg().setValue("-h");
            cl.createArg().setValue(config.getOutputDirectory().getPath());
        }
        if (config.getDebugOutputDirectory() != null && config.getDebugOutputDirectory().getPath().trim().length() != 0) {
            cl.createArg().setValue("-x");
            cl.createArg().setValue(config.getDebugOutputDirectory().getPath());
        }
        cl.createArg().setValue(source.getPath());
        return cl;
    }
}

