/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.rpm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.unix.util.SystemCommand;
import org.codehaus.plexus.util.StringUtils;

public class Rpmbuild {
    private boolean debug;
    private File buildroot;
    private File specFile;
    private String rpmbuildPath = "rpmbuild";
    private List defines = new ArrayList();

    public Rpmbuild setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Rpmbuild setBuildroot(File buildroot) {
        this.buildroot = buildroot;
        return this;
    }

    public Rpmbuild setSpecFile(File specFile) {
        this.specFile = specFile;
        return this;
    }

    public Rpmbuild setRpmbuildPath(String rpmbuildPath) {
        this.rpmbuildPath = StringUtils.defaultString((Object)rpmbuildPath, (String)this.rpmbuildPath);
        return this;
    }

    public Rpmbuild define(String define) {
        this.defines.add(define);
        return this;
    }

    public void buildBinary() throws IOException {
        if (this.specFile == null) {
            throw new IOException("Package specFile is not set.");
        }
        SystemCommand command = new SystemCommand().setBasedir(new File("/"));
        command.dumpCommandIf(this.debug).dumpOutputIf(this.debug).setCommand(this.rpmbuildPath).addArgument("-bb").addArgument("--buildroot").addArgument(this.buildroot.getAbsolutePath()).addArgument("--target").addArgument("noarch").addArgument(this.specFile.getAbsolutePath());
        Iterator it = this.defines.iterator();
        while (it.hasNext()) {
            command.addArgument("--define").addArgument(it.next().toString());
        }
        command.execute().assertSuccess();
    }

    public static boolean available() {
        return SystemCommand.available((String)"rpmbuild");
    }
}

