/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.codehaus.mojo.buildhelper.OsgiArtifactVersion;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="parse-version", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ParseVersionMojo
extends AbstractDefinePropertyMojo {
    @Parameter(defaultValue="${project.version}")
    private String versionString;
    @Parameter(defaultValue="parsedVersion")
    private String propertyPrefix;

    public void execute() {
        this.parseVersion(this.versionString);
    }

    private void defineVersionProperty(String name, String value) {
        this.defineProperty(this.propertyPrefix + '.' + name, value);
    }

    private void defineVersionProperty(String name, int value) {
        this.defineVersionProperty(name, Integer.toString(value));
    }

    public void parseVersion(String version) {
        Object artifactVersion;
        DefaultArtifactVersion releaseVersion = artifactVersion = new DefaultArtifactVersion(version);
        if (ArtifactUtils.isSnapshot((String)version)) {
            releaseVersion = new DefaultArtifactVersion(StringUtils.substring((String)version, (int)0, (int)(version.length() - "SNAPSHOT".length() - 1)));
        }
        if (version.equals(artifactVersion.getQualifier())) {
            this.getLog().debug((CharSequence)"The version is not in the regular format, will try OSGi format instead");
            artifactVersion = new OsgiArtifactVersion(version);
        }
        this.defineVersionProperty("majorVersion", artifactVersion.getMajorVersion());
        this.defineVersionProperty("minorVersion", artifactVersion.getMinorVersion());
        this.defineVersionProperty("incrementalVersion", artifactVersion.getIncrementalVersion());
        this.defineVersionProperty("nextMajorVersion", artifactVersion.getMajorVersion() + 1);
        this.defineVersionProperty("nextMinorVersion", artifactVersion.getMinorVersion() + 1);
        this.defineVersionProperty("nextIncrementalVersion", artifactVersion.getIncrementalVersion() + 1);
        String qualifier = artifactVersion.getQualifier();
        if (qualifier == null) {
            qualifier = "";
        }
        this.defineVersionProperty("qualifier", qualifier);
        this.defineVersionProperty("buildNumber", releaseVersion.getBuildNumber());
        String osgiVersion = this.getOsgiVersion((ArtifactVersion)artifactVersion);
        this.defineVersionProperty("osgiVersion", osgiVersion);
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getOsgiVersion(ArtifactVersion version) {
        if (version.toString().equals(version.getQualifier())) {
            return version.toString();
        }
        StringBuffer osgiVersion = new StringBuffer();
        osgiVersion.append(version.getMajorVersion());
        osgiVersion.append("." + version.getMinorVersion());
        osgiVersion.append("." + version.getIncrementalVersion());
        if (version.getQualifier() != null || version.getBuildNumber() != 0) {
            osgiVersion.append(".");
            if (version.getQualifier() != null) {
                osgiVersion.append(version.getQualifier());
            }
            if (version.getBuildNumber() != 0) {
                osgiVersion.append(version.getBuildNumber());
            }
        }
        return osgiVersion.toString();
    }
}

