/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.ConsoleScanner;
import org.codehaus.mojo.cassandra.Utils;

public class RunCassandraMojo
extends AbstractCassandraMojo {
    protected File script;
    private boolean loadFailureIgnore;
    private boolean loadAfterFirstStart;
    protected File cuDataSet;
    private boolean cuLoadFailureIgnore;
    private boolean cuLoadAfterFirstStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        long timeStamp = System.currentTimeMillis();
        boolean isClean = !this.cassandraDir.isDirectory();
        this.getLog().debug((CharSequence)((isClean ? "First start of Cassandra instance in " : "Re-using existing Cassandra instance in ") + this.cassandraDir.getAbsolutePath()));
        try {
            DefaultExecuteResultHandler execHandler = Utils.startCassandraServer(this.cassandraDir, this.newServiceCommandLine(), this.createEnvironmentVars(), this.getLog());
            try {
                this.getLog().info((CharSequence)"Waiting for Cassandra to start...");
                Utils.waitUntilStarted(this.rpcAddress, this.rpcPort, 0, this.getLog());
                if (isClean && this.loadAfterFirstStart && this.script != null && this.script.isFile()) {
                    this.getLog().info((CharSequence)("Running " + this.script + "..."));
                    int rv = Utils.runLoadScript(this.cassandraDir, this.newCliCommandLine("--file", this.script.getAbsolutePath()), this.createEnvironmentVars(), this.getLog());
                    if (rv != 0) {
                        if (!this.loadFailureIgnore) throw new MojoExecutionException("Command exited with error code " + rv);
                        this.getLog().error((CharSequence)("Command exited with error code " + rv + ". Ignoring as loadFailureIgnore is true"));
                    } else {
                        this.getLog().info((CharSequence)("Finished " + this.script + "."));
                    }
                }
                if (isClean && this.cuLoadAfterFirstStart && this.cuDataSet != null && this.cuDataSet.isFile()) {
                    this.getLog().info((CharSequence)("Loading CassandraUnit dataSet " + this.cuDataSet + "..."));
                    try {
                        DataLoader dataLoader = new DataLoader("cassandraUnitCluster", this.rpcAddress + ":" + this.rpcPort);
                        dataLoader.load((DataSet)new FileDataSet(this.cuDataSet.getAbsolutePath()));
                    }
                    catch (ParseException e) {
                        if (!this.cuLoadFailureIgnore) throw new MojoExecutionException("Error while loading CassandraUnit dataSet", (Exception)((Object)e));
                        this.getLog().error((CharSequence)(e.getMessage() + ". Ignoring as cuLoadFailureIgnore is true"));
                    }
                    this.getLog().info((CharSequence)("Finished " + this.cuDataSet + "."));
                }
                this.getLog().info((CharSequence)("Cassandra started in " + (double)((System.currentTimeMillis() - timeStamp) / 100L) / 10.0 + "s"));
                ConsoleScanner consoleScanner = new ConsoleScanner();
                consoleScanner.start();
                this.getLog().info((CharSequence)"Hit ENTER on the console to stop Cassandra and continue the build.");
                try {
                    consoleScanner.waitForFinished();
                    return;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
            }
            finally {
                Utils.stopCassandraServer(this.rpcAddress, this.rpcPort, this.listenAddress, this.stopPort, this.stopKey, this.getLog());
                try {
                    execHandler.waitFor();
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

