/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.util.IOUtil;

public class CqlExecCassandraMojo
extends AbstractCassandraMojo {
    protected File cqlScript;
    protected String cqlStatement;
    protected String defaultValidator = "BytesType";
    protected String keyValidator = "BytesType";
    protected String comparator = "BytesType";
    protected String cqlVersion = "2.0.0";
    private AbstractType<?> comparatorVal;
    private AbstractType<?> keyValidatorVal;
    private AbstractType<?> defaultValidatorVal;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        try {
            this.comparatorVal = TypeParser.parse((String)this.comparator);
            this.keyValidatorVal = TypeParser.parse((String)this.keyValidator);
            this.defaultValidatorVal = TypeParser.parse((String)this.defaultValidator);
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Could not parse comparator value: " + this.comparator, (Exception)((Object)e));
        }
        catch (SyntaxException e) {
            throw new MojoExecutionException("Could not parse comparator value: " + this.comparator, (Exception)((Object)e));
        }
        ArrayList<CqlExecOperation> cqlOps = new ArrayList<CqlExecOperation>();
        if (this.cqlScript != null && this.cqlScript.isFile()) {
            FileReader fr = null;
            try {
                fr = new FileReader(this.cqlScript);
                this.cqlStatement = IOUtil.toString((Reader)fr);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new MojoExecutionException("Cql file '" + this.cqlScript + "' was deleted before I could read it", (Exception)e);
                    catch (IOException e2) {
                        throw new MojoExecutionException("Could not parse or load cql file", (Exception)e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fr);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)fr);
        }
        if (StringUtils.isBlank((String)this.cqlStatement)) {
            this.getLog().warn((CharSequence)"No CQL provided. Nothing to do.");
            return;
        }
        if (this.cqlStatement.contains(";")) {
            for (String op : StringUtils.split((String)this.cqlStatement, (String)";")) {
                cqlOps.add(this.doExec(op));
            }
        } else {
            cqlOps.add(this.doExec(this.cqlStatement));
        }
        this.printResults(cqlOps);
    }

    private void printResults(List<CqlExecOperation> cqlOps) {
        this.getLog().info((CharSequence)"-----------------------------------------------");
        for (CqlExecOperation cqlExecOperation : cqlOps) {
            while (cqlExecOperation.hasNext()) {
                CqlRow cqlRow = cqlExecOperation.next();
                this.getLog().info((CharSequence)("Row key: " + this.keyValidatorVal.getString(cqlRow.key)));
                this.getLog().info((CharSequence)"-----------------------------------------------");
                for (Column column : cqlRow.getColumns()) {
                    this.getLog().info((CharSequence)(" name: " + this.comparatorVal.getString(column.name)));
                    this.getLog().info((CharSequence)(" value: " + this.defaultValidatorVal.getString(column.value)));
                    this.getLog().info((CharSequence)"-----------------------------------------------");
                }
            }
        }
    }

    private CqlExecOperation doExec(String cqlStatement) throws MojoExecutionException {
        CqlExecOperation cqlOp = new CqlExecOperation(this.rpcAddress, this.rpcPort, cqlStatement);
        if (StringUtils.isNotBlank((String)this.keyspace)) {
            this.getLog().info((CharSequence)("setting keyspace: " + this.keyspace));
            cqlOp.setKeyspace(this.keyspace);
        }
        this.getLog().info((CharSequence)("setting cqlversion: " + this.cqlVersion));
        cqlOp.setCqlVersion(this.cqlVersion);
        try {
            Utils.executeThrift(cqlOp);
        }
        catch (ThriftApiExecutionException taee) {
            throw new MojoExecutionException(taee.getMessage(), (Exception)taee);
        }
        return cqlOp;
    }

    class CqlExecOperation
    extends ThriftApiOperation
    implements Iterator<CqlRow> {
        CqlResult result;
        final ByteBuffer statementBuf;
        CqlRow current;
        Iterator<CqlRow> rowIter;

        public CqlExecOperation(String rpcAddress, int rpcPort, String cqlStatement) {
            super(rpcAddress, rpcPort);
            this.statementBuf = ByteBufferUtil.bytes((String)cqlStatement);
        }

        @Override
        void executeOperation(Cassandra.Client client) throws ThriftApiExecutionException {
            try {
                this.result = "3.0.0".equals(this.getCqlVersion()) ? client.execute_cql3_query(this.statementBuf, Compression.NONE, ConsistencyLevel.ONE) : client.execute_cql_query(this.statementBuf, Compression.NONE);
                this.rowIter = this.result.getRowsIterator();
            }
            catch (Exception e) {
                throw new ThriftApiExecutionException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rowIter != null && this.rowIter.hasNext();
        }

        @Override
        public CqlRow next() {
            this.current = this.rowIter.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.rowIter.remove();
        }

        List<Column> getColumns() {
            return this.current.getColumns();
        }

        ByteBuffer getKey() {
            return this.current.bufferForKey();
        }
    }
}

