/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.announcement;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.maven.changes.ChangesXML;
import org.apache.maven.changes.Release;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class AnnouncementMojo
extends AbstractMojo {
    private String outputDirectory;
    private String groupId;
    private String artifactId;
    private String version;
    private String url;
    private String packaging;
    private String finalName;
    private String urlDownload;
    private String xmlPath;
    private String developmentTeam;
    private String introduction;
    private VelocityComponent velocity;
    private String template;
    private String templateDirectory;
    private boolean useDefaultTemplate;
    private ChangesXML xml;
    private final String CHANGES_XML = "changes.xml";

    public void execute() throws MojoExecutionException {
        String path = this.getXmlPath() + "/" + "changes.xml";
        this.setXml(new ChangesXML(path));
        this.doGenerate(this.getXml());
    }

    public void doGenerate(ChangesXML xml) throws MojoExecutionException {
        try {
            VelocityContext context = new VelocityContext();
            List releaseList = xml.getReleaseList();
            this.getLog().info((CharSequence)"Creating file...");
            if (this.getIntroduction() == null || this.getIntroduction().equals("")) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", (Object)releaseList);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)this.getLatestRelease(releaseList));
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            this.processTemplate((Context)context, this.getOutputDirectory(), this.template);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("resource not found.");
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString());
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.toString());
        }
    }

    public Release getLatestRelease(List releases) throws MojoExecutionException {
        boolean isFound = false;
        Release release = null;
        for (int i = 0; i < releases.size(); ++i) {
            release = (Release)releases.get(i);
            if (!release.getVersion().equals(this.getVersion())) continue;
            isFound = true;
            return release;
        }
        if (!isFound) {
            throw new MojoExecutionException("Make sure that the latest release version of changes.xml matches the version of the POM.");
        }
        return release;
    }

    public void processTemplate(Context context, String outputDirectory, String template) throws ResourceNotFoundException, VelocityException, IOException, MojoExecutionException {
        try {
            File f = new File(outputDirectory, template);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(f);
            this.getVelocity().getEngine().mergeTemplate(this.templateDirectory + "/" + template, context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().info((CharSequence)"File created...");
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )");
        }
        catch (VelocityException ve) {
            throw new VelocityException(ve.toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e.getCause());
        }
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }
}

