/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changes;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.changes.ChangesReportGenerator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class ChangesMojo
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private String xmlPath;
    private String link_template;
    private String url;

    public void executeReport(Locale locale) throws MavenReportException {
        File xmlFile = new File(this.xmlPath);
        if (!xmlFile.exists()) {
            this.getLog().error((CharSequence)this.getBundle(locale).getString("report.changes.error"));
            ChangesReportGenerator report = new ChangesReportGenerator();
            report.doGenerateEmptyReport(this.getBundle(locale), this.getSink(), this.getBundle(locale).getString("report.changes.error"));
        } else {
            ChangesReportGenerator report = new ChangesReportGenerator(this.xmlPath);
            if (this.url == null) {
                this.getLog().warn((CharSequence)this.getBundle(locale).getString("report.changes.warn.url"));
            }
            report.setIssueLink(this.link_template);
            report.setUrl(this.url);
            report.doGenerateReport(this.getBundle(locale), this.getSink());
        }
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.changes.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.changes.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return "changes-report";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

