/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jira;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.jira.JiraDownloader2;
import org.apache.maven.jira.JiraReportGenerator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class JiraMojo
extends AbstractMavenReport {
    private String outputDirectory;
    private String xmlPath;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private Settings settings;
    private int maxEntries;
    private String filter;
    private String statusIds;
    private String resolutionIds;
    private String priorityIds;
    private String component;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.validateIfIssueManagementComplete()) {
            JiraDownloader2 jira = new JiraDownloader2();
            this.setJiraDownloaderParameter(jira);
            try {
                jira.doExecute();
                JiraReportGenerator report = new JiraReportGenerator(this.xmlPath);
                report.doGenerateReport(this.getBundle(locale), this.getSink());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            JiraReportGenerator report = new JiraReportGenerator();
            report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
        }
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jira.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jira.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return "jira-report";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jira-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void setJiraDownloaderParameter(JiraDownloader2 jira) {
        jira.setLog(this.getLog());
        jira.setMavenProject(this.project);
        jira.setOutput(new File(this.xmlPath));
        jira.setNbEntries(this.maxEntries);
        jira.setComponent(this.component);
        jira.setStatusIds(this.statusIds);
        jira.setResolutionIds(this.resolutionIds);
        jira.setPriorityIds(this.priorityIds);
        jira.setFilter(this.filter);
        jira.setJiraUser(this.jiraUser);
        jira.setJiraPassword(this.jiraPassword);
        jira.setWebUser(this.webUser);
        jira.setWebPassword(this.webPassword);
        jira.setSettings(this.settings);
    }

    private boolean validateIfIssueManagementComplete() {
        if (this.project.getIssueManagement() == null) {
            this.getLog().error((CharSequence)"No Issue Management set. Jira Report will not be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getUrl() == null) {
            this.getLog().error((CharSequence)"No URL set in Issue Management. Jira Report will not be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getSystem() != null && !this.project.getIssueManagement().getSystem().equalsIgnoreCase("jira")) {
            this.getLog().error((CharSequence)"Jira Report only supports JIRA.  Jira Report will not be generated.");
            return false;
        }
        return true;
    }
}

