/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.announcement;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.mailsender.simple.SimpleMailMessage;
import org.codehaus.plexus.util.IOUtil;

public class AnnouncementMailMojo
extends AbstractMojo {
    private MavenProject project;
    private String smtpHost;
    private int smtpPort;
    private String subject;
    private List toAddresses;
    private List from;
    private String file;
    private SimpleMailMessage simpleMailMessage;

    public void execute() throws MojoExecutionException {
        if (this.isTextFileExisting(this.getFile())) {
            for (int i = 0; i < this.getToAddresses().size(); ++i) {
                String email = this.getToAddresses().get(i).toString();
                this.sendMessage(email);
            }
        } else {
            throw new MojoExecutionException("Announcement template not found...");
        }
    }

    protected void sendMessage(String recipient) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Connecting to Host: " + this.getSmtpHost() + " : " + this.getSmtpPort()));
            this.getLog().info((CharSequence)(this.getFile() + " found..."));
            this.simpleMailMessage = new SimpleMailMessage(this.getSmtpHost(), this.getSmtpPort());
            this.simpleMailMessage.from(this.getFirstDevEmail(this.getFrom()));
            this.simpleMailMessage.to(recipient);
            this.simpleMailMessage.setSubject(this.getSubject());
            this.simpleMailMessage.getPrintStream().print(IOUtil.toString((Reader)this.readAnnouncement(this.getFile())));
            this.getLog().info((CharSequence)("Sending mail... " + this.getToAddresses()));
            this.simpleMailMessage.sendAndClose();
            this.getLog().info((CharSequence)"[INFO] Sent...");
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to send email.", (Exception)ioe);
        }
    }

    protected boolean isTextFileExisting(String fileName) {
        boolean found = false;
        File f = new File(fileName);
        if (f.exists()) {
            found = true;
        }
        return found;
    }

    public FileReader readAnnouncement(String fileName) throws MojoExecutionException {
        FileReader fileReader = null;
        try {
            File file = new File(fileName);
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("File not found. " + fileName);
        }
        return fileReader;
    }

    public String getFirstDevEmail(List fromNames) throws MojoExecutionException {
        String fromAddress = "";
        if (fromNames.size() > 0) {
            Developer developer = (Developer)fromNames.get(0);
            fromAddress = developer.getEmail();
            this.getLog().info((CharSequence)("email retrieved. " + fromAddress));
            if (fromAddress == null || fromAddress.equals("")) {
                throw new MojoExecutionException("Email address in <developers> section is required.");
            }
        } else {
            throw new MojoExecutionException("Email address in <developers> section is required.");
        }
        return fromAddress;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List getFrom() {
        return this.from;
    }

    public void setFrom(List from) {
        this.from = from;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List toAddresses) {
        this.toAddresses = toAddresses;
    }
}

