/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.ArtifactHelper;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.LicenseMap;
import org.codehaus.mojo.license.MavenProjectDependenciesLoader;
import org.codehaus.mojo.license.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddThirdPartyMojo
extends AbstractAddThirdPartyMojo
implements MavenProjectDependenciesLoader {
    protected ArtifactRepository localRepository;
    protected List<?> remoteRepositories;
    protected MavenProjectBuilder mavenProjectBuilder;
    private boolean doGenerateMissing;

    @Override
    protected boolean checkPackaging() {
        return this.rejectPackaging("pom");
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return ArtifactHelper.loadProjectDependencies(this, this.getLog(), AddThirdPartyMojo.getArtifactCache());
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException {
        SortedProperties unsafeMappings = this.getLicenseMap().loadUnsafeMapping(AddThirdPartyMojo.getArtifactCache(), this.getEncoding(), this.getMissingFile());
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("found " + unsafeMappings.size() + " unsafe mappings"));
        }
        boolean generateMissingfile = this.computeDoGenerateMissingFile(unsafeMappings, unsafeDependencies);
        this.setDoGenerateMissing(generateMissingfile);
        if (generateMissingfile && this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Will use from missing file ");
            sb.append(unsafeMappings.size());
            sb.append(" dependencies :");
            for (Map.Entry<Object, Object> entry : unsafeMappings.entrySet()) {
                String id = (String)entry.getKey();
                String license = (String)entry.getValue();
                sb.append("\n - ").append(id).append(" - ").append(license);
            }
            this.getLog().info((CharSequence)sb.toString());
        } else if (this.isUseMissingFile() && !unsafeMappings.isEmpty()) {
            this.getLog().info((CharSequence)("Missing file " + this.getMissingFile() + " is up-to-date."));
        }
        return unsafeMappings;
    }

    protected boolean computeDoGenerateMissingFile(SortedProperties unsafeMappings, SortedSet<MavenProject> unsafeDependencies) throws IOException {
        if (!this.isUseMissingFile()) {
            return false;
        }
        if (this.isForce()) {
            return !CollectionUtils.isEmpty(unsafeMappings.keySet());
        }
        if (!CollectionUtils.isEmpty(unsafeDependencies)) {
            return true;
        }
        SortedProperties oldUnsafeMappings = new SortedProperties(this.getEncoding());
        oldUnsafeMappings.load(this.getMissingFile());
        return !unsafeMappings.equals(oldUnsafeMappings);
    }

    @Override
    protected boolean checkSkip() {
        if (!(this.isDoGenerate() || this.isDoGenerateBundle() || this.isDoGenerateMissing())) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        boolean unsafe = this.checkUnsafeDependencies();
        this.writeThirdPartyFile();
        if (this.isDoGenerateMissing()) {
            this.writeMissingFile();
        }
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please fill the file " + this.getMissingFile());
        }
        this.addResourceDir(this.getOutputDirectory(), "**/*.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMissingFile() throws IOException {
        Log log = this.getLog();
        LicenseMap licenseMap = this.getLicenseMap();
        File file = this.getMissingFile();
        FileUtil.createDirectoryIfNecessary(file.getParentFile());
        log.info((CharSequence)("Regenerate missing license file " + file));
        FileOutputStream writer = new FileOutputStream(file);
        try {
            StringBuilder sb = new StringBuilder(" Generated by " + this.getClass().getName());
            ArrayList licenses = new ArrayList(licenseMap.keySet());
            licenses.remove(LicenseMap.getUnknownLicenseMessage());
            if (!licenses.isEmpty()) {
                sb.append("\n-------------------------------------------------------------------------------");
                sb.append("\n Already used licenses in project :");
                for (String license : licenses) {
                    sb.append("\n - ").append(license);
                }
            }
            sb.append("\n-------------------------------------------------------------------------------");
            sb.append("\n Please fill the missing licenses for dependencies :\n\n");
            this.getUnsafeMappings().store(writer, sb.toString());
        }
        finally {
            writer.close();
        }
    }

    public boolean isDoGenerateMissing() {
        return this.doGenerateMissing;
    }

    public void setDoGenerateMissing(boolean doGenerateMissing) {
        this.doGenerateMissing = doGenerateMissing;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public List<?> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public MavenProjectBuilder getMavenProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludeScopes() {
        return Arrays.asList("system");
    }
}

