/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentStyleListMojo
extends AbstractLicenseMojo {
    private boolean detail;
    private Map<String, FileHeaderTransformer> transformers;

    @Override
    protected void init() throws Exception {
    }

    @Override
    public void doAction() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           license-maven-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        ArrayList<String> names = new ArrayList<String>(this.transformers.keySet());
        Collections.sort(names);
        int maxLength = 0;
        int maxDLength = 0;
        for (String name : names) {
            FileHeaderTransformer transformer;
            if (name.length() > maxLength) {
                maxLength = name.length();
            }
            if ((transformer = this.transformers.get(name)).getDescription().length() <= maxDLength) continue;
            maxDLength = transformer.getDescription().length();
        }
        String pattern = "  - %1$-" + maxLength + "s : %2$-" + maxDLength + "s, extensions : %3$s\n";
        buffer.append("List of available comment styles:\n\n");
        for (String transformerName : names) {
            FileHeaderTransformer transformer = this.transformers.get(transformerName);
            buffer.append(String.format(pattern, transformerName, transformer.getDescription(), Arrays.toString(transformer.getDefaultAcceptedExtensions())));
            if (!this.detail) continue;
            buffer.append("\n   example : \n");
            buffer.append(transformer.boxComment("header", true));
            buffer.append('\n');
        }
        this.getLog().info((CharSequence)buffer.toString());
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public Map<String, FileHeaderTransformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Map<String, FileHeaderTransformer> transformers) {
        this.transformers = transformers;
    }
}

