/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.MajorMinorIncrementalFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-latest-releases", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseLatestReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useLatestReleases(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestReleases(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                Dependency dependency = new Dependency();
                dependency.setArtifactId(this.getProject().getParent().getArtifactId());
                dependency.setGroupId(this.getProject().getParent().getGroupId());
                dependency.setVersion(this.getProject().getParent().getVersion());
                dependency.setType("pom");
                ArrayList<Dependency> list = new ArrayList<Dependency>();
                list.add(dependency);
                this.useLatestReleases(pom, list);
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useLatestReleases(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        int segment = this.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        MajorMinorIncrementalFilter majorMinorIncfilter = new MajorMinorIncrementalFilter(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        for (Dependency dep : dependencies) {
            Artifact artifact;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches() || !this.isIncluded(artifact = this.toArtifact(dep))) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(version);
            this.getLog().debug((CharSequence)("Selected version: " + selectedVersion));
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            try {
                ArtifactVersion[] newer = versions.getNewerVersions(version, segment, false);
                ArtifactVersion[] filteredVersions = majorMinorIncfilter.filter((ArtifactVersion)selectedVersion, newer = this.filterVersionsWithIncludes(newer, artifact));
                if (filteredVersions.length <= 0) continue;
                String newVersion = filteredVersions[filteredVersions.length - 1].toString();
                if (this.getProject().getParent() != null && artifact.getId().equals(this.getProject().getParentArtifact().getId()) && this.isProcessingParent() && PomHelper.setProjectParentVersion(pom, newVersion)) {
                    this.getLog().debug((CharSequence)("Made parent update from " + version + " to " + newVersion));
                }
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion, this.getProject().getModel())) continue;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
                this.getChangeRecorder().recordUpdate("useLatestReleases", dep.getGroupId(), dep.getArtifactId(), version, newVersion);
            }
            catch (InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s:%s due to: %s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), e.getMessage()));
            }
        }
    }

    private ArtifactVersion[] filterVersionsWithIncludes(ArtifactVersion[] newer, Artifact artifact) {
        ArrayList<ArtifactVersion> filteredNewer = new ArrayList<ArtifactVersion>(newer.length);
        for (int j = 0; j < newer.length; ++j) {
            ArtifactVersion artifactVersion = newer[j];
            DefaultArtifact artefactWithNewVersion = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion((String)artifactVersion.toString()), artifact.getScope(), artifact.getType(), null, (ArtifactHandler)new DefaultArtifactHandler(), false);
            if (!this.isIncluded((Artifact)artefactWithNewVersion)) continue;
            filteredNewer.add(artifactVersion);
        }
        return filteredNewer.toArray(new ArtifactVersion[filteredNewer.size()]);
    }
}

