/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webminifier;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:webminifier-maven-plugin:1.0.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Web Minifier Maven Plugin", 0);
        this.append(sb, "Provides JS minification capabilities.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "webminifier:help", 0);
            this.append(sb, "Display help information on webminifier-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0webminifier:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "minify-js".equals(this.goal)) {
            this.append(sb, "webminifier:minify-js", 0);
            this.append(sb, "Mojo to invoke WebMinifier plugin to minify web files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "closureAcceptConstKeyword (Default: false)", 2);
                this.append(sb, "Whether or not the const keyword is to be accepted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "closureCompilationLevel (Default: SIMPLE_OPTIMIZATIONS)", 2);
                this.append(sb, "Closure compiler level option either:\n1.\tWHITESPACE_ONLY\n2.\tSIMPLE_OPTIMIZATIONS\n3.\tADVANCED_OPTIMIZATIONS\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "destinationFolder (Default: ${project.build.directory}/min/classes)", 2);
                this.append(sb, "The output folder to write minified files to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "All HTML, JavaScript and CSS files are assumed to have this encoding. \ufffd", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlExcludes", 2);
                this.append(sb, "Do not process HTML files which match these patterns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlIncludes", 2);
                this.append(sb, "Process HTML files which match these patterns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jsCompressorType (Default: CLOSURE)", 2);
                this.append(sb, "The type of compressor to use for JS files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jsSplitPoints", 2);
                this.append(sb, "If a JavaScript resource contains one of these target/classes/js relative file names is found while minifying it will be the last script file appended to the current minified script file. A new minified script will be created for the next file, if one exists. Each name in the property corresponds to the relative file path of a file accessible from the destinationFolder e.g. js/a.js would match up with a file located at target/classes/js/a.js. Each property value, if provided, corresponds to the name component of a file that will be generated and without the file extension. If omitted then a numbering scheme will be employed to name the file at the split point.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectSourceFolder (Default: ${basedir}/src/main)", 2);
                this.append(sb, "The project source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceFolder (Default: ${project.build.directory}/classes)", 2);
                this.append(sb, "The source folder with un-minified files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "splitDependencies (Default: true)", 2);
                this.append(sb, "Signals whether or not dependencies should be minified into their own file. For applications, you may want to put everything in a single minified file, but for libraries you do not.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "yuiDisableOptimizations (Default: false)", 2);
                this.append(sb, "YUI option 'disableOptimizations'; disable all micro-optimizations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "yuiLinebreak (Default: -1)", 2);
                this.append(sb, "YUI option 'linebreak'; insert a linebreak after VALUE columnns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "yuiMunge (Default: true)", 2);
                this.append(sb, "YUI option 'munge'; minify and obfuscate. If false, minify only.", 3);
                this.append(sb, "", 0);
                this.append(sb, "yuiPreserveSemi (Default: false)", 2);
                this.append(sb, "YUI option 'preserveSemi'; preserve semicolons before }.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

