/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.engine.NameValuePair;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class WebTestException
extends BuildException {
    private Step fFailedStep;
    private final List details = new ArrayList();
    private final String fShortMessage;
    private final String urlCurrentResponse_;

    protected WebTestException(String message, Throwable cause) {
        super(message, cause);
        this.fShortMessage = message;
        this.urlCurrentResponse_ = WebTestException.readUrlCurrentResponse();
    }

    private static String readUrlCurrentResponse() {
        Page currentResponse = WebtestTask.getThreadContext().getCurrentResponse();
        if (currentResponse == null) {
            return "-- none --";
        }
        return currentResponse.getUrl().toExternalForm();
    }

    protected WebTestException(String message, Step failedStep, Throwable cause) {
        this(message, cause);
        this.fFailedStep = failedStep;
    }

    protected WebTestException(String message, Step failedStep) {
        this(message, failedStep, null);
    }

    protected WebTestException(String shortMessage, String messageEnd, Step failedStep) {
        super(shortMessage + messageEnd);
        this.fShortMessage = shortMessage;
        this.fFailedStep = failedStep;
        this.urlCurrentResponse_ = WebTestException.readUrlCurrentResponse();
    }

    public List getDetails() {
        return this.details;
    }

    public void addDetail(String name, String value) {
        this.details.add(new NameValuePair(name, value));
    }

    public String getShortMessage() {
        return this.fShortMessage;
    }

    public String toString() {
        if (this.fFailedStep == null) {
            return super.toString();
        }
        return super.toString() + ", Step: " + this.fFailedStep.toString();
    }

    public String getUrlCurrentResponse() {
        return this.urlCurrentResponse_;
    }
}

