/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyValuePdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import com.canoo.webtest.util.ConversionUtil;

public class PdfVerifyEncryptionPropertyStep
extends AbstractVerifyValuePdfStep {
    private String fKey;

    public String getKey() {
        return this.fKey;
    }

    public void setKey(String key) {
        this.fKey = key;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getKey(), "key");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        String actualValue = pdfPage.getEncryptProperty(this.getKey());
        if (this.getExists() != null) {
            boolean exists = ConversionUtil.convertToBoolean(this.getExists(), true);
            if (exists && actualValue == null || !exists && actualValue != null) {
                StringBuffer sb = new StringBuffer("Encrypt property with key \"");
                sb.append(this.getKey());
                sb.append("\" should ");
                if (!exists) {
                    sb.append("not ");
                }
                sb.append("exist");
                throw new StepFailedException(sb.toString(), this);
            }
        } else {
            boolean regex = ConversionUtil.convertToBoolean(this.getRegex(), false);
            if (!PdfVerifyEncryptionPropertyStep.getVerifier(regex).verifyStrings(this.getValue(), actualValue)) {
                throw new StepFailedException("Wrong encrypt property value for key \"" + this.getKey() + "\"", this.getValue(), actualValue);
            }
        }
    }
}

