/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:webtest-maven-plugin:1.0.0-alpha-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Canoo WebTest Maven Plugin", 0);
        this.append(sb, "Canoo WebTest plugin for Maven2 and Maven3. Canoo WebTest is a free Java tools for functional testing of web applications and the plugin allows to run Canoo Webtests from within a Maven build.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "webtest:clean", 0);
            this.append(sb, "Remove temporary data from running the Canoo WebTests. The following directories are deleted\n-\tresultpath\n-\treportdirectory\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autorefresh (Default: true)", 2);
                this.append(sb, "Specifies whether the client should automatically follow page refresh requests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.autorefresh}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basepath", 2);
                this.append(sb, "Defines the constant base path used to construct request URLs, e.g. 'shop' can be considered a basepath in 'http:/www.myhost.com/shop/productlist' and 'http:/www.myhost.com/shop/checkout'.", 3);
                this.append(sb, "Expression: ${webtest.basepath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failureproperty", 2);
                this.append(sb, "Specifies the name of an ant property which is set to true if the test fails. When using this property, set 'haltonfailure' to 'false'. Then check the ant property after performing all of your tests and if set fail. This allows your tests to continue running even if some fail (allowing you to catch multiple errors with one test run) but still ultimately fails the build if anything went wrong.", 3);
                this.append(sb, "Expression: ${webtest.failureproperty}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonerror (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current <webtest< stops if a program error (unhandled exception) is encountered in one of the test steps. An ANT BuildFailed exception will be raised if it is set to 'Yes'. This will terminate the execution of the ANT script. Setting the option to 'false' will stop the execution of the current <webtest> but continues with the next ANT task, e.g. another <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonerror}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonfailure (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current test halts if a failure of one of the test steps is detected, e.g. a <verify...> test did not pass. Even when set to 'false' all of the trailing <step>s of the current <webtest> will be skipped but processing will continue with the next <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonfailure}", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "Defines the hostname to use for executing requests, e.g. 'localhost' or 'www.myhost.com'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.host}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loglevel (Default: WARN)", 2);
                this.append(sb, "Defines the loglevel passed to the ANT script", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.loglevel}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 80)", 2);
                this.append(sb, "Defines the port number to use for executing requests, e.g. '8080'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyprefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "Expression: ${webtest.propertyprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: http)", 2);
                this.append(sb, "Defines the protocol to use for executing requests. 'http:' and 'file:' are currently the only supported protocols.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory (Default: ${basedir}/target/site/webtest)", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportdirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname (Default: index.html)", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath (Default: ${project.build.directory}/webtest/webtest-results)", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.resultpath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultreporterclass (Default: com.canoo.webtest.reporting.XmlReporter)", 2);
                this.append(sb, "Defines the class for report generation, e.g 'com.canoo.webtest.reporting.PlainTextReporter' or 'com.canoo.webtest.reporting.XmlReporter'.", 3);
                this.append(sb, "Expression: ${webtest.resultreporterclass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveprefix (Default: response)", 2);
                this.append(sb, "Sets the name to use if the current response received from the target host is to be saved into a file. A unique id will also be appended after the prefix.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveresponse (Default: true)", 2);
                this.append(sb, "Defines whether the last response received from the target host is saved into the file <saveprefix><uniqueId>.html. saveprefix is the value set in the <saveprefix> config element. uniqueId is a timestamp at the time the file is saved. This is especially helpful for debugging your tests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveresponse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcedirectory (Default: ${basedir}/src/test/webtest)", 2);
                this.append(sb, "Specifies the location of the source files to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcedirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcefile (Default: webtest.xml)", 2);
                this.append(sb, "The ANT file to be executed as globbing pattern within the 'sourcedirectory'. Depending on you requirements you can choose a different file or multiple files. The default value is '${basedir}/src/test/webtest/webtest.xml'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcefile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: all)", 2);
                this.append(sb, "The ANT target to call when executing a Canoo WebTest script.", 3);
                this.append(sb, "Expression: ${webtest.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 300)", 2);
                this.append(sb, "Defines the timeout value in seconds for both connection and socket. The connection timeout is the maximum allowed time until a connection is etablished. The socket timeout is the timeout for waiting for data. A timeout value of zero is interpreted as an infinite timeout.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "webtest:help", 0);
            this.append(sb, "Display help information on webtest-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0webtest:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "info".equals(this.goal)) {
            this.append(sb, "webtest:info", 0);
            this.append(sb, "Prints the configuration settings.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autorefresh (Default: true)", 2);
                this.append(sb, "Specifies whether the client should automatically follow page refresh requests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.autorefresh}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basepath", 2);
                this.append(sb, "Defines the constant base path used to construct request URLs, e.g. 'shop' can be considered a basepath in 'http:/www.myhost.com/shop/productlist' and 'http:/www.myhost.com/shop/checkout'.", 3);
                this.append(sb, "Expression: ${webtest.basepath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failureproperty", 2);
                this.append(sb, "Specifies the name of an ant property which is set to true if the test fails. When using this property, set 'haltonfailure' to 'false'. Then check the ant property after performing all of your tests and if set fail. This allows your tests to continue running even if some fail (allowing you to catch multiple errors with one test run) but still ultimately fails the build if anything went wrong.", 3);
                this.append(sb, "Expression: ${webtest.failureproperty}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonerror (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current <webtest< stops if a program error (unhandled exception) is encountered in one of the test steps. An ANT BuildFailed exception will be raised if it is set to 'Yes'. This will terminate the execution of the ANT script. Setting the option to 'false' will stop the execution of the current <webtest> but continues with the next ANT task, e.g. another <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonerror}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonfailure (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current test halts if a failure of one of the test steps is detected, e.g. a <verify...> test did not pass. Even when set to 'false' all of the trailing <step>s of the current <webtest> will be skipped but processing will continue with the next <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonfailure}", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "Defines the hostname to use for executing requests, e.g. 'localhost' or 'www.myhost.com'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.host}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loglevel (Default: WARN)", 2);
                this.append(sb, "Defines the loglevel passed to the ANT script", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.loglevel}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 80)", 2);
                this.append(sb, "Defines the port number to use for executing requests, e.g. '8080'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyprefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "Expression: ${webtest.propertyprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: http)", 2);
                this.append(sb, "Defines the protocol to use for executing requests. 'http:' and 'file:' are currently the only supported protocols.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory (Default: ${basedir}/target/site/webtest)", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportdirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname (Default: index.html)", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath (Default: ${project.build.directory}/webtest/webtest-results)", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.resultpath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultreporterclass (Default: com.canoo.webtest.reporting.XmlReporter)", 2);
                this.append(sb, "Defines the class for report generation, e.g 'com.canoo.webtest.reporting.PlainTextReporter' or 'com.canoo.webtest.reporting.XmlReporter'.", 3);
                this.append(sb, "Expression: ${webtest.resultreporterclass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveprefix (Default: response)", 2);
                this.append(sb, "Sets the name to use if the current response received from the target host is to be saved into a file. A unique id will also be appended after the prefix.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveresponse (Default: true)", 2);
                this.append(sb, "Defines whether the last response received from the target host is saved into the file <saveprefix><uniqueId>.html. saveprefix is the value set in the <saveprefix> config element. uniqueId is a timestamp at the time the file is saved. This is especially helpful for debugging your tests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveresponse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcedirectory (Default: ${basedir}/src/test/webtest)", 2);
                this.append(sb, "Specifies the location of the source files to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcedirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcefile (Default: webtest.xml)", 2);
                this.append(sb, "The ANT file to be executed as globbing pattern within the 'sourcedirectory'. Depending on you requirements you can choose a different file or multiple files. The default value is '${basedir}/src/test/webtest/webtest.xml'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcefile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: all)", 2);
                this.append(sb, "The ANT target to call when executing a Canoo WebTest script.", 3);
                this.append(sb, "Expression: ${webtest.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 300)", 2);
                this.append(sb, "Defines the timeout value in seconds for both connection and socket. The connection timeout is the maximum allowed time until a connection is etablished. The socket timeout is the timeout for waiting for data. A timeout value of zero is interpreted as an infinite timeout.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "loop".equals(this.goal)) {
            this.append(sb, "webtest:loop", 0);
            this.append(sb, "Runs a Canoo WebTest in a loop until an error or failure occurs. This is handy when load testing and running the Canoo WebTests in parallel to ensure that the application still works.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autorefresh (Default: true)", 2);
                this.append(sb, "Specifies whether the client should automatically follow page refresh requests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.autorefresh}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basepath", 2);
                this.append(sb, "Defines the constant base path used to construct request URLs, e.g. 'shop' can be considered a basepath in 'http:/www.myhost.com/shop/productlist' and 'http:/www.myhost.com/shop/checkout'.", 3);
                this.append(sb, "Expression: ${webtest.basepath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failureproperty", 2);
                this.append(sb, "Specifies the name of an ant property which is set to true if the test fails. When using this property, set 'haltonfailure' to 'false'. Then check the ant property after performing all of your tests and if set fail. This allows your tests to continue running even if some fail (allowing you to catch multiple errors with one test run) but still ultimately fails the build if anything went wrong.", 3);
                this.append(sb, "Expression: ${webtest.failureproperty}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonerror (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current <webtest< stops if a program error (unhandled exception) is encountered in one of the test steps. An ANT BuildFailed exception will be raised if it is set to 'Yes'. This will terminate the execution of the ANT script. Setting the option to 'false' will stop the execution of the current <webtest> but continues with the next ANT task, e.g. another <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonerror}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonfailure (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current test halts if a failure of one of the test steps is detected, e.g. a <verify...> test did not pass. Even when set to 'false' all of the trailing <step>s of the current <webtest> will be skipped but processing will continue with the next <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonfailure}", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "Defines the hostname to use for executing requests, e.g. 'localhost' or 'www.myhost.com'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.host}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loglevel (Default: WARN)", 2);
                this.append(sb, "Defines the loglevel passed to the ANT script", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.loglevel}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loops", 2);
                this.append(sb, "Defines the number of iterations for 'webtest:loop'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: 10", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 80)", 2);
                this.append(sb, "Defines the port number to use for executing requests, e.g. '8080'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyprefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "Expression: ${webtest.propertyprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: http)", 2);
                this.append(sb, "Defines the protocol to use for executing requests. 'http:' and 'file:' are currently the only supported protocols.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory (Default: ${basedir}/target/site/webtest)", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportdirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname (Default: index.html)", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath (Default: ${project.build.directory}/webtest/webtest-results)", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.resultpath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultreporterclass (Default: com.canoo.webtest.reporting.XmlReporter)", 2);
                this.append(sb, "Defines the class for report generation, e.g 'com.canoo.webtest.reporting.PlainTextReporter' or 'com.canoo.webtest.reporting.XmlReporter'.", 3);
                this.append(sb, "Expression: ${webtest.resultreporterclass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveprefix (Default: response)", 2);
                this.append(sb, "Sets the name to use if the current response received from the target host is to be saved into a file. A unique id will also be appended after the prefix.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveresponse (Default: true)", 2);
                this.append(sb, "Defines whether the last response received from the target host is saved into the file <saveprefix><uniqueId>.html. saveprefix is the value set in the <saveprefix> config element. uniqueId is a timestamp at the time the file is saved. This is especially helpful for debugging your tests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveresponse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcedirectory (Default: ${basedir}/src/test/webtest)", 2);
                this.append(sb, "Specifies the location of the source files to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcedirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcefile (Default: webtest.xml)", 2);
                this.append(sb, "The ANT file to be executed as globbing pattern within the 'sourcedirectory'. Depending on you requirements you can choose a different file or multiple files. The default value is '${basedir}/src/test/webtest/webtest.xml'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcefile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: all)", 2);
                this.append(sb, "The ANT target to call when executing a Canoo WebTest script.", 3);
                this.append(sb, "Expression: ${webtest.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 300)", 2);
                this.append(sb, "Defines the timeout value in seconds for both connection and socket. The connection timeout is the maximum allowed time until a connection is etablished. The socket timeout is the timeout for waiting for data. A timeout value of zero is interpreted as an infinite timeout.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "webtest:report", 0);
            this.append(sb, "Creates the HTML report for a test run based on XSLT.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}/target/site/webtest", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: index.html", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportoverviewxsl", 2);
                this.append(sb, "Defines the XSLT used to generate the WebTest report overview covering all test.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: WebTestReportOverview.xsl", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response). Under this directory Canoo WebTest will created test-related subfolders, e.g. '001_GreenTest'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/webtest/webtest-results", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test".equals(this.goal)) {
            this.append(sb, "webtest:test", 0);
            this.append(sb, "Runs a Canoo WebTest defined in an ANT script.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autorefresh (Default: true)", 2);
                this.append(sb, "Specifies whether the client should automatically follow page refresh requests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.autorefresh}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basepath", 2);
                this.append(sb, "Defines the constant base path used to construct request URLs, e.g. 'shop' can be considered a basepath in 'http:/www.myhost.com/shop/productlist' and 'http:/www.myhost.com/shop/checkout'.", 3);
                this.append(sb, "Expression: ${webtest.basepath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failureproperty", 2);
                this.append(sb, "Specifies the name of an ant property which is set to true if the test fails. When using this property, set 'haltonfailure' to 'false'. Then check the ant property after performing all of your tests and if set fail. This allows your tests to continue running even if some fail (allowing you to catch multiple errors with one test run) but still ultimately fails the build if anything went wrong.", 3);
                this.append(sb, "Expression: ${webtest.failureproperty}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonerror (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current <webtest< stops if a program error (unhandled exception) is encountered in one of the test steps. An ANT BuildFailed exception will be raised if it is set to 'Yes'. This will terminate the execution of the ANT script. Setting the option to 'false' will stop the execution of the current <webtest> but continues with the next ANT task, e.g. another <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonerror}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonfailure (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current test halts if a failure of one of the test steps is detected, e.g. a <verify...> test did not pass. Even when set to 'false' all of the trailing <step>s of the current <webtest> will be skipped but processing will continue with the next <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonfailure}", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "Defines the hostname to use for executing requests, e.g. 'localhost' or 'www.myhost.com'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.host}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loglevel (Default: WARN)", 2);
                this.append(sb, "Defines the loglevel passed to the ANT script", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.loglevel}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 80)", 2);
                this.append(sb, "Defines the port number to use for executing requests, e.g. '8080'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyprefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "Expression: ${webtest.propertyprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: http)", 2);
                this.append(sb, "Defines the protocol to use for executing requests. 'http:' and 'file:' are currently the only supported protocols.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory (Default: ${basedir}/target/site/webtest)", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportdirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname (Default: index.html)", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath (Default: ${project.build.directory}/webtest/webtest-results)", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.resultpath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultreporterclass (Default: com.canoo.webtest.reporting.XmlReporter)", 2);
                this.append(sb, "Defines the class for report generation, e.g 'com.canoo.webtest.reporting.PlainTextReporter' or 'com.canoo.webtest.reporting.XmlReporter'.", 3);
                this.append(sb, "Expression: ${webtest.resultreporterclass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveprefix (Default: response)", 2);
                this.append(sb, "Sets the name to use if the current response received from the target host is to be saved into a file. A unique id will also be appended after the prefix.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveresponse (Default: true)", 2);
                this.append(sb, "Defines whether the last response received from the target host is saved into the file <saveprefix><uniqueId>.html. saveprefix is the value set in the <saveprefix> config element. uniqueId is a timestamp at the time the file is saved. This is especially helpful for debugging your tests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveresponse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sleepbeforestart", 2);
                this.append(sb, "Defines the number of seconds to wait before starting a test.", 3);
                this.append(sb, "Expression: 0", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcedirectory (Default: ${basedir}/src/test/webtest)", 2);
                this.append(sb, "Specifies the location of the source files to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcedirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcefile (Default: webtest.xml)", 2);
                this.append(sb, "The ANT file to be executed as globbing pattern within the 'sourcedirectory'. Depending on you requirements you can choose a different file or multiple files. The default value is '${basedir}/src/test/webtest/webtest.xml'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcefile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: all)", 2);
                this.append(sb, "The ANT target to call when executing a Canoo WebTest script.", 3);
                this.append(sb, "Expression: ${webtest.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 300)", 2);
                this.append(sb, "Defines the timeout value in seconds for both connection and socket. The connection timeout is the maximum allowed time until a connection is etablished. The socket timeout is the timeout for waiting for data. A timeout value of zero is interpreted as an infinite timeout.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "verify-filecontent".equals(this.goal)) {
            this.append(sb, "webtest:verify-filecontent", 0);
            this.append(sb, "Allows grepping through a set of files to find particular text strings and fail the build if one or matches are found. This is useful for checking HTML files ('an application error occured') or logfiles to decide if any exception are silently ignored by the web application.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileContentValidationSets", 2);
                this.append(sb, "Specifies a set of files, which are being validated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "verify-result".equals(this.goal)) {
            this.append(sb, "webtest:verify-result", 0);
            this.append(sb, "Checks the webtest result file for test failures and throws an exception if one or more tests failed. This is useful when 'haltonfailure' and 'haltonerror' are set to 'false' thereby indicating a successful build even in the case that nothing worked. Invoking 'webtest:verify' allows to fail the build later on behalf of the user.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autorefresh (Default: true)", 2);
                this.append(sb, "Specifies whether the client should automatically follow page refresh requests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.autorefresh}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basepath", 2);
                this.append(sb, "Defines the constant base path used to construct request URLs, e.g. 'shop' can be considered a basepath in 'http:/www.myhost.com/shop/productlist' and 'http:/www.myhost.com/shop/checkout'.", 3);
                this.append(sb, "Expression: ${webtest.basepath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failureproperty", 2);
                this.append(sb, "Specifies the name of an ant property which is set to true if the test fails. When using this property, set 'haltonfailure' to 'false'. Then check the ant property after performing all of your tests and if set fail. This allows your tests to continue running even if some fail (allowing you to catch multiple errors with one test run) but still ultimately fails the build if anything went wrong.", 3);
                this.append(sb, "Expression: ${webtest.failureproperty}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonerror (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current <webtest< stops if a program error (unhandled exception) is encountered in one of the test steps. An ANT BuildFailed exception will be raised if it is set to 'Yes'. This will terminate the execution of the ANT script. Setting the option to 'false' will stop the execution of the current <webtest> but continues with the next ANT task, e.g. another <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonerror}", 3);
                this.append(sb, "", 0);
                this.append(sb, "haltonfailure (Default: false)", 2);
                this.append(sb, "Determines if the execution of the current test halts if a failure of one of the test steps is detected, e.g. a <verify...> test did not pass. Even when set to 'false' all of the trailing <step>s of the current <webtest> will be skipped but processing will continue with the next <webtest>.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.haltonfailure}", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "Defines the hostname to use for executing requests, e.g. 'localhost' or 'www.myhost.com'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.host}", 3);
                this.append(sb, "", 0);
                this.append(sb, "loglevel (Default: WARN)", 2);
                this.append(sb, "Defines the loglevel passed to the ANT script", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.loglevel}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 80)", 2);
                this.append(sb, "Defines the port number to use for executing requests, e.g. '8080'.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyprefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "Expression: ${webtest.propertyprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: http)", 2);
                this.append(sb, "Defines the protocol to use for executing requests. 'http:' and 'file:' are currently the only supported protocols.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportdirectory (Default: ${basedir}/target/site/webtest)", 2);
                this.append(sb, "The subdirectory created under site containing the webtest report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportdirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportname (Default: index.html)", 2);
                this.append(sb, "The name of the created report using XSLT", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.reportname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultpath (Default: ${project.build.directory}/webtest/webtest-results)", 2);
                this.append(sb, "Defines the resultpath of saved responses (for example last response).", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.resultpath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultreporterclass (Default: com.canoo.webtest.reporting.XmlReporter)", 2);
                this.append(sb, "Defines the class for report generation, e.g 'com.canoo.webtest.reporting.PlainTextReporter' or 'com.canoo.webtest.reporting.XmlReporter'.", 3);
                this.append(sb, "Expression: ${webtest.resultreporterclass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveprefix (Default: response)", 2);
                this.append(sb, "Sets the name to use if the current response received from the target host is to be saved into a file. A unique id will also be appended after the prefix.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveprefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "saveresponse (Default: true)", 2);
                this.append(sb, "Defines whether the last response received from the target host is saved into the file <saveprefix><uniqueId>.html. saveprefix is the value set in the <saveprefix> config element. uniqueId is a timestamp at the time the file is saved. This is especially helpful for debugging your tests.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.saveresponse}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcedirectory (Default: ${basedir}/src/test/webtest)", 2);
                this.append(sb, "Specifies the location of the source files to be used.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcedirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcefile (Default: webtest.xml)", 2);
                this.append(sb, "The ANT file to be executed as globbing pattern within the 'sourcedirectory'. Depending on you requirements you can choose a different file or multiple files. The default value is '${basedir}/src/test/webtest/webtest.xml'", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.sourcefile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: all)", 2);
                this.append(sb, "The ANT target to call when executing a Canoo WebTest script.", 3);
                this.append(sb, "Expression: ${webtest.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 300)", 2);
                this.append(sb, "Defines the timeout value in seconds for both connection and socket. The connection timeout is the maximum allowed time until a connection is etablished. The socket timeout is the timeout for waiting for data. A timeout value of zero is interpreted as an infinite timeout.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${webtest.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

