/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cache.builder;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.cache.Cache;
import org.codehaus.plexus.cache.builder.CacheBuilder;
import org.codehaus.plexus.cache.impl.NoCacheCache;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class DefaultCacheBuilder
extends AbstractLogEnabled
implements CacheBuilder,
Initializable,
Contextualizable,
Disposable {
    private Cache defaultCache;
    private PlexusContainer plexusContainer;
    private Cache noCache = new NoCacheCache();

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        if (this.plexusContainer.hasComponent(Cache.ROLE, "default")) {
            try {
                this.defaultCache = (Cache)this.plexusContainer.lookup(Cache.ROLE, "default");
            }
            catch (ComponentLookupException e) {
                String emsg = "error during lookup of Cache with role-hint default ";
                this.getLogger().warn(emsg, (Throwable)e);
                throw new InitializationException(emsg, (Throwable)e);
            }
        } else {
            this.getLogger().info("Cache with role-hint default doesn't exists, default will be no cache");
            this.defaultCache = new NoCacheCache();
        }
    }

    public Cache getCache(String roleHint) {
        try {
            return (Cache)this.plexusContainer.lookup(Cache.ROLE, roleHint);
        }
        catch (ComponentLookupException e) {
            this.getLogger().warn("error during lookup of Cache with roleHint " + roleHint);
            return this.getDefaultCache();
        }
    }

    public Cache getCache(Class clazz) {
        return this.getCache(clazz.getName());
    }

    public void dispose() {
    }

    public Cache getDefaultCache() {
        return this.defaultCache == null ? this.noCache : this.defaultCache;
    }
}

