/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cache.ehcache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.codehaus.plexus.cache.Cache;
import org.codehaus.plexus.cache.CacheStatistics;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class EhcacheCache
extends AbstractLogEnabled
implements Cache,
Initializable,
Disposable {
    private long diskExpiryThreadIntervalSeconds = 600L;
    private boolean diskPersistent = true;
    private String diskStorePath = System.getProperty("java.io.tmpdir") + "/ehcache";
    private boolean eternal = false;
    private int maxElementsInMemory = 1000;
    private String memoryEvictionPolicy = "LRU";
    private String name = "cache";
    private boolean overflowToDisk = false;
    private int timeToIdleSeconds = 600;
    private int timeToLiveSeconds = 300;
    private CacheManager cacheManager;
    private net.sf.ehcache.Cache ehcache;
    private Stats stats;

    public void clear() {
        this.ehcache.removeAll();
        this.stats.clear();
    }

    public void dispose() {
        if (this.cacheManager.getStatus().equals(Status.STATUS_ALIVE)) {
            this.getLogger().info("Disposing cache: " + this.ehcache);
            if (this.ehcache != null) {
                this.cacheManager.removeCache(this.ehcache.getName());
                this.ehcache = null;
            }
        } else {
            this.getLogger().debug("Not disposing cache, because cacheManager is not alive: " + this.ehcache);
        }
    }

    public Object get(Object key) {
        Element elem = this.ehcache.get(key);
        if (elem == null) {
            return null;
        }
        return elem.getObjectValue();
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public String getMemoryEvictionPolicy() {
        return this.memoryEvictionPolicy;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return MemoryStoreEvictionPolicy.fromString((String)this.memoryEvictionPolicy);
    }

    public String getName() {
        return this.name;
    }

    public CacheStatistics getStatistics() {
        return this.stats;
    }

    public int getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean hasKey(Object key) {
        return this.ehcache.isKeyInCache(key);
    }

    public void initialize() throws InitializationException {
        this.stats = new Stats();
        this.cacheManager = CacheManager.getInstance();
        if (this.cacheManager.cacheExists(this.getName())) {
            throw new InitializationException("A previous cache with name [" + this.getName() + "] exists.");
        }
        this.ehcache = new net.sf.ehcache.Cache(this.getName(), this.getMaxElementsInMemory(), this.getMemoryStoreEvictionPolicy(), this.isOverflowToDisk(), this.getDiskStorePath(), this.isEternal(), (long)this.getTimeToLiveSeconds(), (long)this.getTimeToIdleSeconds(), this.isDiskPersistent(), this.getDiskExpiryThreadIntervalSeconds(), null);
        this.cacheManager.addCache(this.ehcache);
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public void register(Object key, Object value) {
        this.ehcache.put(new Element(key, value));
    }

    public Object put(Object key, Object value) {
        Element elem = null;
        Object previous = null;
        elem = this.ehcache.get(key);
        if (elem != null) {
            previous = elem.getObjectValue();
        }
        elem = new Element(key, value);
        this.ehcache.put(elem);
        return previous;
    }

    public Object remove(Object key) {
        Element elem = null;
        Object previous = null;
        elem = this.ehcache.get(key);
        if (elem != null) {
            previous = elem.getObjectValue();
            this.ehcache.remove(key);
        }
        return previous;
    }

    public void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMemoryEvictionPolicy(String memoryEvictionPolicy) {
        this.memoryEvictionPolicy = memoryEvictionPolicy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setTimeToIdleSeconds(int timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    class Stats
    implements CacheStatistics {
        Stats() {
        }

        public void clear() {
            EhcacheCache.this.ehcache.clearStatistics();
        }

        public double getCacheHitRate() {
            double hits = this.getCacheHits();
            double miss = this.getCacheMiss();
            if (hits == 0.0 && hits == 0.0) {
                return 0.0;
            }
            return hits / (hits + miss);
        }

        public long getCacheHits() {
            return EhcacheCache.this.ehcache.getStatistics().getCacheHits();
        }

        public long getCacheMiss() {
            return EhcacheCache.this.ehcache.getStatistics().getCacheMisses();
        }

        public long getSize() {
            return EhcacheCache.this.ehcache.getMemoryStoreSize() + (long)EhcacheCache.this.ehcache.getDiskStoreSize();
        }
    }
}

