/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cache.ehcache;

import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.codehaus.plexus.cache.Cache;
import org.codehaus.plexus.cache.CacheException;
import org.codehaus.plexus.cache.CacheHints;
import org.codehaus.plexus.cache.ehcache.EhcacheCache;
import org.codehaus.plexus.cache.factory.CacheCreator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class EhcacheCreator
implements CacheCreator {
    public Cache createCache(CacheHints hints) throws CacheException {
        EhcacheCache cache = new EhcacheCache();
        cache.setName(hints.getName());
        cache.setDiskPersistent(hints.isOverflowToDisk());
        if (hints.isOverflowToDisk()) {
            File overflowPath = null;
            if (hints.getDiskOverflowPath() != null) {
                overflowPath = hints.getDiskOverflowPath();
            } else {
                File tmpDir = SystemUtils.getJavaIoTmpDir();
                overflowPath = new File(tmpDir, "ehcache/" + hints.getName());
            }
            cache.setDiskStorePath(overflowPath.getAbsolutePath());
        }
        cache.setMaxElementsInMemory(hints.getMaxElements());
        cache.setTimeToLiveSeconds(hints.getMaxSecondsInCache());
        cache.setTimeToIdleSeconds(hints.getIdleExpirationSeconds());
        try {
            cache.initialize();
        }
        catch (InitializationException e) {
            throw new CacheException("Unable to initialize EhcacheCache: " + e.getMessage(), (Throwable)e);
        }
        return cache;
    }
}

