/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.authentication.keystore;

import javax.annotation.Resource;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.Authenticator;
import org.codehaus.plexus.redback.authentication.TokenBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticator#keystore")
public class KeyStoreAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="keyManager#cached")
    private KeyManager keystore;
    @Resource(name="userManager#configurable")
    private UserManager userManager;

    public String getId() {
        return "$Id: KeyStoreAuthenticator.java 789 2009-03-12 06:52:37Z brett $";
    }

    public AuthenticationResult authenticate(AuthenticationDataSource source) throws AccountLockedException, AuthenticationException, MustChangePasswordException {
        TokenBasedAuthenticationDataSource dataSource = (TokenBasedAuthenticationDataSource)source;
        String key = dataSource.getToken();
        try {
            AuthenticationKey authKey = this.keystore.findKey(key);
            if (authKey != null) {
                User user = this.userManager.findUser(dataSource.getPrincipal());
                if (user.isLocked()) {
                    throw new AccountLockedException("Account " + source.getPrincipal() + " is locked.", user);
                }
                if (user.isPasswordChangeRequired() && source.isEnforcePasswordChange()) {
                    throw new MustChangePasswordException("Password expired.", user);
                }
                return new AuthenticationResult(true, (Object)dataSource.getPrincipal(), null);
            }
            return new AuthenticationResult(false, (Object)dataSource.getPrincipal(), (Exception)new AuthenticationException("unable to find key"));
        }
        catch (KeyNotFoundException ne) {
            return new AuthenticationResult(false, null, (Exception)((Object)ne));
        }
        catch (KeyManagerException ke) {
            throw new AuthenticationException("underlaying keymanager issue", (Throwable)ke);
        }
        catch (UserNotFoundException e) {
            this.log.warn("Login for user " + source.getPrincipal() + " failed. user not found.");
            return new AuthenticationResult(false, null, (Exception)((Object)e));
        }
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof TokenBasedAuthenticationDataSource;
    }
}

