/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.authentication.ldap;

import javax.annotation.Resource;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.Authenticator;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnection;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionFactory;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="authenticator#ldap")
public class LdapBindAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="userMapper#ldap")
    private UserMapper mapper;
    @Resource(name="ldapConnectionFactory#configurable")
    private LdapConnectionFactory connectionFactory;
    @Resource(name="userConfiguration")
    private UserConfiguration config;

    public String getId() {
        return "LdapBindAuthenticator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(AuthenticationDataSource s) throws AuthenticationException {
        PasswordBasedAuthenticationDataSource source = (PasswordBasedAuthenticationDataSource)s;
        if (!this.config.getBoolean("ldap.bind.authenticator.enabled")) {
            return new AuthenticationResult(false, (Object)source.getPrincipal(), null);
        }
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass=" + this.mapper.getUserObjectClass() + ")" + (this.mapper.getUserFilter() != null ? this.mapper.getUserFilter() : "") + "(" + this.mapper.getUserIdAttribute() + "=" + source.getPrincipal() + "))";
        this.log.info("Searching for users with filter: '" + filter + "'" + " from base dn: " + this.mapper.getUserBaseDn());
        LdapConnection ldapConnection = this.getLdapConnection();
        LdapConnection authLdapConnection = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            DirContext context = ldapConnection.getDirContext();
            results = context.search(this.mapper.getUserBaseDn(), filter, ctls);
            this.log.info("Found user?: " + results.hasMoreElements());
            if (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                String userDn = result.getNameInNamespace();
                this.log.info("Attempting Authenication: + " + userDn);
                authLdapConnection = this.connectionFactory.getConnection(userDn, source.getPassword());
                AuthenticationResult authenticationResult = new AuthenticationResult(true, (Object)source.getPrincipal(), null);
                this.closeNamingEnumeration(results);
                this.closeLdapConnection(ldapConnection);
                if (authLdapConnection != null) {
                    this.closeLdapConnection(authLdapConnection);
                }
                return authenticationResult;
            }
            AuthenticationResult authenticationResult = new AuthenticationResult(false, (Object)source.getPrincipal(), null);
            return authenticationResult;
        }
        catch (LdapException e) {
            AuthenticationResult authenticationResult = new AuthenticationResult(false, (Object)source.getPrincipal(), (Exception)((Object)e));
            return authenticationResult;
        }
        catch (NamingException e) {
            AuthenticationResult authenticationResult = new AuthenticationResult(false, (Object)source.getPrincipal(), (Exception)e);
            return authenticationResult;
        }
        finally {
            this.closeNamingEnumeration(results);
            this.closeLdapConnection(ldapConnection);
            if (authLdapConnection != null) {
                this.closeLdapConnection(authLdapConnection);
            }
        }
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof PasswordBasedAuthenticationDataSource;
    }

    private LdapConnection getLdapConnection() {
        try {
            return this.connectionFactory.getConnection();
        }
        catch (LdapException e) {
            this.log.warn("failed to get a ldap connection " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("failed to get a ldap connection " + e.getMessage(), e);
        }
    }

    private void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }

    private void closeNamingEnumeration(NamingEnumeration<SearchResult> results) {
        try {
            if (results != null) {
                results.close();
            }
        }
        catch (NamingException e) {
            this.log.warn("skip exception closing naming search result " + e.getMessage());
        }
    }
}

