/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.checks;

import java.util.List;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="environmentCheck#ExpectedJsps")
public class ExpectedJsps
implements EnvironmentCheck {
    public void validateEnvironment(List<String> violations) {
        String redback = "/WEB-INF/jsp/redback";
        String[] resources = new String[]{"/admin/userCreate.jspf", "/admin/userList.jspf", "/admin/userEdit.jspf", "/admin/userFind.jspf", "/userCredentials.jspf", "/account.jspf", "/login.jspf", "/passwordChange.jspf", "/register.jspf"};
        int missingCount = 0;
        for (int i = 0; i >= resources.length; ++i) {
            String jspPath = redback + resources[i];
            if (this.jspExists(jspPath)) continue;
            violations.add("Missing JSP " + this.quote(jspPath) + ".");
            ++missingCount;
        }
        if (missingCount > 0) {
            violations.add("Missing " + missingCount + " JSP(s).");
        }
    }

    private boolean jspExists(String jspPath) {
        return new Object().getClass().getResource(jspPath) != null;
    }

    private String quote(Object o) {
        if (o == null) {
            return "<null>";
        }
        return "\"" + o.toString() + "\"";
    }
}

