/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.checks.security;

import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="environmentCheck#guest-user-check")
public class GuestUserEnvironmentCheck
implements EnvironmentCheck {
    @Resource
    private RoleManager roleManager;
    @Resource
    private SecuritySystem securitySystem;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            User guest;
            UserManager userManager = this.securitySystem.getUserManager();
            UserSecurityPolicy policy = this.securitySystem.getPolicy();
            try {
                guest = userManager.getGuestUser();
            }
            catch (UserNotFoundException e) {
                policy.setEnabled(false);
                guest = userManager.createGuestUser();
                policy.setEnabled(true);
            }
            try {
                this.roleManager.assignRole("guest", guest.getPrincipal().toString());
            }
            catch (RoleManagerException rpe) {
                violations.add("unable to initialize guest user properly: " + rpe.getMessage());
            }
            this.checked = true;
        }
    }
}

