/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.checks.security;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="environmentCheck#locked-admin-check")
public class LockedAdminEnvironmentCheck
implements EnvironmentCheck {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="userManager#configurable")
    private UserManager userManager;
    @Resource(name="rBACManager#cached")
    private RBACManager rbacManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked && !this.userManager.isReadOnly()) {
            ArrayList<String> roles = new ArrayList<String>();
            roles.add("System Administrator");
            try {
                List systemAdminstrators = this.rbacManager.getUserAssignmentsForRoles(roles);
                for (UserAssignment userAssignment : systemAdminstrators) {
                    try {
                        User admin = this.userManager.findUser(userAssignment.getPrincipal());
                        if (!admin.isLocked()) continue;
                        this.log.info("Unlocking system administrator: " + admin.getUsername());
                        admin.setLocked(false);
                        this.userManager.updateUser(admin);
                    }
                    catch (UserNotFoundException ne) {
                        this.log.warn("Dangling UserAssignment -> " + userAssignment.getPrincipal());
                    }
                }
            }
            catch (RbacManagerException e) {
                this.log.warn("Exception when checking for locked admin user: " + e.getMessage(), (Throwable)e);
            }
            this.checked = true;
        }
    }
}

