/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.checks.security;

import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="environmentCheck#required-roles")
public class RequiredRolesEnvironmentCheck
implements EnvironmentCheck {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RoleManager roleManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            this.log.info("Checking the existence of required roles.");
            try {
                if (!this.roleManager.roleExists("registered-user")) {
                    violations.add("unable to validate existence of the registered-user role");
                }
                if (!this.roleManager.roleExists("user-administrator")) {
                    violations.add("unable to validate existence of the user-administator role");
                }
                if (!this.roleManager.roleExists("system-administrator")) {
                    violations.add("unable to validate existence of the system-administrator role");
                }
            }
            catch (RoleManagerException e) {
                violations.add("unable to check required roles: " + e.getMessage());
            }
            this.checked = true;
        }
    }
}

