/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.filter;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.spring.PlexusToSpringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class PlexusServletFilter
implements Filter {
    private ApplicationContext applicationContext;
    private Logger logger;

    public void destroy() {
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object lookup(String role) throws ServletException {
        Object o = this.getApplicationContext().getBean(PlexusToSpringUtils.buildSpringId((String)role));
        if (o == null) {
            throw new ServletException("Unable to lookup plexus component '" + role + "'.");
        }
        return o;
    }

    public Object lookup(String role, String hint) throws ServletException {
        Object o = this.getApplicationContext().getBean(PlexusToSpringUtils.buildSpringId((String)role, (String)hint));
        if (o == null) {
            throw new ServletException("Unable to lookup plexus component '" + role + "'.");
        }
        return o;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        LoggerManager loggerManager = (LoggerManager)this.getApplicationContext().getBean(PlexusToSpringUtils.buildSpringId((String)LoggerManager.ROLE));
        this.logger = loggerManager.getLoggerForComponent(this.getClass().getName());
        if (this.logger == null) {
            throw new ServletException("Unable to lookup Logger from plexus.");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }
}

