/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.filter.authentication;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.filter.authentication.HttpAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAuthenticator {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ROLE = HttpAuthenticator.class.getName();
    @Resource
    protected SecuritySystem securitySystem;

    public AuthenticationResult authenticate(AuthenticationDataSource ds, HttpSession httpSession) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        try {
            SecuritySession securitySession = this.securitySystem.authenticate(ds);
            this.setSecuritySession(securitySession, httpSession);
            return securitySession.getAuthenticationResult();
        }
        catch (AuthenticationException e) {
            String msg = "Unable to authenticate user: " + ds;
            this.log.info(msg, (Throwable)e);
            throw new HttpAuthenticationException(msg, e);
        }
        catch (UserNotFoundException e) {
            this.log.info("Login attempt against unknown user: " + ds);
            throw new HttpAuthenticationException("User name or password invalid.");
        }
    }

    public void authenticate(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            AuthenticationResult result = this.getAuthenticationResult(request, response);
            if (result == null || !result.isAuthenticated()) {
                throw new HttpAuthenticationException("You are not authenticated.");
            }
        }
        catch (AccountLockedException e) {
            throw new HttpAuthenticationException("Your account is locked.");
        }
        catch (MustChangePasswordException e) {
            throw new HttpAuthenticationException("You must change your password.");
        }
    }

    public abstract void challenge(HttpServletRequest var1, HttpServletResponse var2, String var3, AuthenticationException var4) throws IOException;

    public abstract AuthenticationResult getAuthenticationResult(HttpServletRequest var1, HttpServletResponse var2) throws AuthenticationException, AccountLockedException, MustChangePasswordException;

    public User getSessionUser(HttpSession httpSession) {
        return (User)httpSession.getAttribute("SecuritySessionUser");
    }

    public boolean isAlreadyAuthenticated(HttpSession httpSession) {
        User user = this.getSessionUser(httpSession);
        return user != null && !user.isLocked() && !user.isPasswordChangeRequired();
    }

    public SecuritySession getSecuritySession(HttpSession httpSession) {
        return (SecuritySession)httpSession.getAttribute(SecuritySession.ROLE);
    }

    public void setSecuritySession(SecuritySession session, HttpSession httpSession) {
        httpSession.setAttribute(SecuritySession.ROLE, (Object)session);
        httpSession.setAttribute("SecuritySessionUser", (Object)session.getUser());
    }

    public void setSessionUser(User user, HttpSession httpSession) {
        httpSession.setAttribute(SecuritySession.ROLE, null);
        httpSession.setAttribute("SecuritySessionUser", (Object)user);
    }

    public String storeDefaultUser(String principal, HttpSession httpSession) {
        httpSession.setAttribute(SecuritySession.ROLE, null);
        httpSession.setAttribute("SecuritySessionUser", null);
        if (StringUtils.isEmpty((String)principal)) {
            return null;
        }
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            httpSession.setAttribute("SecuritySessionUser", (Object)user);
            return user.getPrincipal().toString();
        }
        catch (UserNotFoundException e) {
            this.log.warn("Default User '" + principal + "' not found.", (Throwable)e);
            return null;
        }
    }
}

