/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.filter.authentication.basic;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.filter.authentication.HttpAuthenticator;
import org.springframework.stereotype.Service;

@Service(value="httpAuthenticator#basic")
public class HttpBasicAuthentication
extends HttpAuthenticator {
    public String getId() {
        return HttpBasicAuthentication.class.getName();
    }

    public AuthenticationResult getAuthenticationResult(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        HttpSession httpSession = request.getSession(true);
        if (this.isAlreadyAuthenticated(httpSession)) {
            return this.getSecuritySession(httpSession).getAuthenticationResult();
        }
        String header = request.getHeader("Authorization");
        if (header == null) {
            header = request.getHeader("authorization");
        }
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(58);
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            PasswordBasedAuthenticationDataSource authDataSource = new PasswordBasedAuthenticationDataSource(username, password);
            return super.authenticate((AuthenticationDataSource)authDataSource, httpSession);
        }
        return null;
    }

    public void challenge(HttpServletRequest request, HttpServletResponse response, String realmName, AuthenticationException exception) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        String message = "You must provide a username and password to access this resource.";
        if (exception != null && StringUtils.isNotEmpty((String)exception.getMessage())) {
            message = exception.getMessage();
        }
        response.sendError(401, message);
    }
}

