/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.filter.authorization;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.filter.PlexusServletFilter;

public class SimpleAuthorizationFilter
extends PlexusServletFilter {
    private String permission;
    private String resource;
    private String accessDeniedLocation;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.permission = filterConfig.getInitParameter("permission");
        this.resource = filterConfig.getInitParameter("resource");
        this.accessDeniedLocation = filterConfig.getInitParameter("accessDeniedLocation");
        if (StringUtils.isEmpty((String)this.accessDeniedLocation)) {
            throw new ServletException("Missing parameter 'accessDeniedLocation' from " + SimpleAuthorizationFilter.class.getName() + " configuration.");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecuritySession securitySession = (SecuritySession)this.lookup(SecuritySession.ROLE);
        if (securitySession == null) {
            this.getLogger().warn("Security Session is null.");
            return;
        }
        SecuritySystem securitySystem = (SecuritySystem)this.lookup(SecuritySystem.ROLE);
        boolean isAuthorized = false;
        try {
            isAuthorized = StringUtils.isEmpty((String)this.resource) ? securitySystem.isAuthorized(securitySession, (Object)this.permission) : securitySystem.isAuthorized(securitySession, (Object)this.permission, (Object)this.resource);
            if (isAuthorized) {
                chain.doFilter(request, response);
            } else {
                this.accessDenied(response);
            }
        }
        catch (AuthorizationException e) {
            this.accessDenied(response);
        }
    }

    protected void accessDenied(ServletResponse response) throws IOException {
        String newlocation = this.accessDeniedLocation;
        newlocation = newlocation.indexOf(63) == -1 ? newlocation + "?" : newlocation + "&";
        newlocation = newlocation + "resource=" + this.resource;
        ((HttpServletResponse)response).sendRedirect(newlocation);
    }
}

