/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureActionBundle {
    private boolean requiresAuthentication = false;
    private List<AuthorizationTuple> authorizationTuples = new ArrayList<AuthorizationTuple>();
    public static final SecureActionBundle OPEN = new SecureActionBundle();
    public static final SecureActionBundle AUTHONLY = new SecureActionBundle();

    public void addRequiredAuthorization(String operation, String resource) throws SecureActionException {
        if (operation == null || resource == null) {
            throw new SecureActionException("operation and resource are required to be non-null");
        }
        this.authorizationTuples.add(new AuthorizationTuple(operation, resource));
    }

    public void addRequiredAuthorization(String operation) throws SecureActionException {
        if (operation == null) {
            throw new SecureActionException("operation is required to be non-null");
        }
        this.authorizationTuples.add(new AuthorizationTuple(operation, "*"));
    }

    public List<AuthorizationTuple> getAuthorizationTuples() {
        return this.authorizationTuples;
    }

    public boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    public void setRequiresAuthentication(boolean requiresAuthentication) {
        this.requiresAuthentication = requiresAuthentication;
    }

    static {
        AUTHONLY.setRequiresAuthentication(true);
    }

    public static class AuthorizationTuple {
        private String operation;
        private String resource;

        public AuthorizationTuple(String operation, String resource) {
            this.operation = operation;
            this.resource = resource;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getResource() {
            return this.resource;
        }

        public String toString() {
            return "AuthorizationTuple[" + this.operation + "," + this.resource + "]";
        }
    }
}

