/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.UserValidationSettings;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.mail.MailGenerator;
import org.codehaus.redback.integration.mail.Mailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="mailer")
public class MailerImpl
implements Mailer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="mailGenerator#velocity")
    private MailGenerator generator;
    @Resource(name="mailSender")
    private JavaMailSender javaMailSender;
    @Resource
    private SecuritySystem securitySystem;
    @Resource(name="userConfiguration")
    private UserConfiguration config;

    @Override
    public void sendAccountValidationEmail(Collection<String> recipients, AuthenticationKey authkey, String baseUrl) {
        String content = this.generator.generateMail("newAccountValidationEmail", authkey, baseUrl);
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        UserValidationSettings validation = policy.getUserValidationSettings();
        this.sendMessage(recipients, validation.getEmailSubject(), content);
    }

    @Override
    public void sendPasswordResetEmail(Collection<String> recipients, AuthenticationKey authkey, String baseUrl) {
        String content = this.generator.generateMail("passwordResetEmail", authkey, baseUrl);
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        UserValidationSettings validation = policy.getUserValidationSettings();
        this.sendMessage(recipients, validation.getEmailSubject(), content);
    }

    @Override
    public void sendMessage(Collection<String> recipients, String subject, String content) {
        if (recipients.isEmpty()) {
            this.log.warn("Mail Not Sent - No mail recipients for email. subject [" + subject + "]");
            return;
        }
        String fromAddress = this.config.getString("email.from.address");
        String fromName = this.config.getString("email.from.name");
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = System.getProperty("user.name") + "@localhost";
        }
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            message.setSubject(subject);
            message.setText(content);
            InternetAddress from = new InternetAddress(fromAddress, fromName);
            message.setFrom((Address)from);
            ArrayList<InternetAddress> tos = new ArrayList<InternetAddress>();
            for (String mailbox : recipients) {
                InternetAddress to = new InternetAddress(mailbox.trim());
                tos.add(to);
            }
            message.setRecipients(Message.RecipientType.TO, tos.toArray(new Address[tos.size()]));
            this.log.debug(content);
            this.javaMailSender.send(message);
        }
        catch (AddressException e) {
            this.log.error("Unable to send message, subject [" + subject + "]", (Throwable)e);
        }
        catch (MessagingException e) {
            this.log.error("Unable to send message, subject [" + subject + "]", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unable to send message, subject [" + subject + "]", (Throwable)e);
        }
    }
}

