/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.mail;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.codehaus.redback.integration.mail.MailGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mailGenerator#velocity")
public class VelocityMailGenerator
implements MailGenerator {
    private Logger log = LoggerFactory.getLogger(VelocityMailGenerator.class);
    @Resource(name="userConfiguration")
    private UserConfiguration config;
    @Resource
    private VelocityComponent velocity;

    public String generateMail(String templateName, AuthenticationKey authkey, String baseUrl) {
        VelocityContext context = this.createVelocityContext(authkey, baseUrl);
        String packageName = this.getClass().getPackage().getName().replace('.', '/');
        String templateFile = packageName + "/template/" + templateName + ".vm";
        StringWriter writer = new StringWriter();
        try {
            this.velocity.getEngine().mergeTemplate(templateFile, (Context)context, (Writer)writer);
        }
        catch (ResourceNotFoundException e) {
            this.log.error("No such template: '" + templateFile + "'.");
        }
        catch (ParseErrorException e) {
            this.log.error("Unable to generate email for template '" + templateFile + "': " + e.getMessage(), (Throwable)e);
        }
        catch (MethodInvocationException e) {
            this.log.error("Unable to generate email for template '" + templateFile + "': " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Unable to generate email for template '" + templateFile + "': " + e.getMessage(), (Throwable)e);
        }
        return writer.getBuffer().toString();
    }

    private VelocityContext createVelocityContext(AuthenticationKey authkey, String appUrl) {
        VelocityContext context = new VelocityContext();
        context.put("applicationUrl", (Object)this.config.getString("application.url", appUrl));
        String feedback = this.config.getString("email.feedback.path");
        if (feedback != null) {
            if (feedback.startsWith("/")) {
                feedback = appUrl + feedback;
            }
            context.put("feedback", (Object)feedback);
        }
        context.put("authkey", (Object)authkey.getKey());
        context.put("accountId", (Object)authkey.getForPrincipal());
        SimpleDateFormat dateformatter = new SimpleDateFormat(this.config.getString("application.timestamp"), Locale.US);
        context.put("requestedOn", (Object)dateformatter.format(authkey.getDateCreated()));
        if (authkey.getDateExpires() != null) {
            context.put("expiresOn", (Object)dateformatter.format(authkey.getDateExpires()));
        } else {
            context.put("expiresOn", (Object)"(does not expire)");
        }
        return context;
    }
}

