/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.reports;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.redback.integration.reports.Report;
import org.codehaus.redback.integration.reports.ReportException;
import org.codehaus.redback.integration.util.RoleSorter;
import org.codehaus.redback.integration.util.UserComparator;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="report#rolesmatrix-csv")
public class CsvRolesMatrix
implements Report {
    @Resource
    private SecuritySystem securitySystem;
    @Resource(name="rBACManager#jdo")
    private RBACManager rbacManager;

    @Override
    public String getName() {
        return "Roles Matrix";
    }

    @Override
    public String getType() {
        return "csv";
    }

    @Override
    public void writeReport(OutputStream os) throws ReportException {
        HashMap<String, List<String>> assignmentsMap;
        List allRoles;
        UserManager userManager = this.securitySystem.getUserManager();
        List allUsers = userManager.getUsers();
        try {
            allRoles = this.rbacManager.getAllRoles();
            Collections.sort(allRoles, new RoleSorter());
            assignmentsMap = new HashMap<String, List<String>>();
            for (UserAssignment assignment : this.rbacManager.getAllUserAssignments()) {
                assignmentsMap.put(assignment.getPrincipal(), assignment.getRoleNames());
            }
        }
        catch (RbacManagerException e) {
            throw new ReportException("Unable to obtain list of all roles.", e);
        }
        Collections.sort(allUsers, new UserComparator("username", true));
        PrintWriter out = new PrintWriter(os);
        this.writeCsvHeader(out, allRoles);
        for (User user : allUsers) {
            this.writeCsvRow(out, user, assignmentsMap, allRoles);
        }
        out.flush();
    }

    private void writeCsvHeader(PrintWriter out, List<Role> allRoles) {
        out.print("Username,Full Name,Email Address");
        for (Role role : allRoles) {
            out.print("," + this.escapeCell(role.getName()));
        }
        out.println();
    }

    private void writeCsvRow(PrintWriter out, User user, Map<String, List<String>> assignmentsMap, List<Role> allRoles) {
        out.print(this.escapeCell(user.getUsername()));
        out.print("," + this.escapeCell(user.getFullName()));
        out.print("," + this.escapeCell(user.getEmail()));
        List<String> assignedRoleNames = assignmentsMap.get(user.getPrincipal().toString());
        if (assignedRoleNames == null) {
            assignedRoleNames = new ArrayList<String>();
        }
        for (Role role : allRoles) {
            out.print(',');
            if (!assignedRoleNames.contains(role.getName())) continue;
            out.print('Y');
        }
        out.println();
    }

    private String escapeCell(String cell) {
        return "\"" + StringEscapeUtils.escapeJava((String)cell) + "\"";
    }

    @Override
    public String getId() {
        return "rolesmatrix";
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }
}

