/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.reports;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.redback.integration.reports.Report;
import org.codehaus.redback.integration.reports.ReportException;
import org.codehaus.redback.integration.util.UserComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="report#userlist-csv")
public class CsvUserList
implements Report {
    private Logger log = LoggerFactory.getLogger(CsvUserList.class);
    @Resource
    private SecuritySystem securitySystem;
    private Map<String, String> fields = new HashMap<String, String>();

    public CsvUserList() {
        this.fields.put("username", "User Name");
        this.fields.put("fullName", "Full Name");
        this.fields.put("email", "Email Address");
        this.fields.put("permanent", "Permanent User");
        this.fields.put("locked", "Locked User");
        this.fields.put("validated", "Validated User");
        this.fields.put("passwordChangeRequired", "Must Change Password On Next Login");
        this.fields.put("countFailedLoginAttempts", "Failed Login Attempts");
        this.fields.put("lastPasswordChange", "Last Password Change");
        this.fields.put("accountCreationDate", "Date Created");
        this.fields.put("lastLoginDate", "Date Last Logged In");
    }

    public String getId() {
        return "userlist";
    }

    public String getMimeType() {
        return "text/csv";
    }

    public String getName() {
        return "User List";
    }

    public String getType() {
        return "csv";
    }

    public void writeReport(OutputStream os) throws ReportException {
        UserManager userManager = this.securitySystem.getUserManager();
        List allUsers = userManager.getUsers();
        Collections.sort(allUsers, new UserComparator("username", true));
        PrintWriter out = new PrintWriter(os);
        this.writeCsvHeader(out);
        for (User user : allUsers) {
            this.writeCsvRow(out, user);
        }
        out.flush();
    }

    private void writeCsvHeader(PrintWriter out) {
        boolean hasPreviousField = false;
        for (String heading : this.fields.values()) {
            if (hasPreviousField) {
                out.print(",");
            }
            out.print(this.escapeCell(heading));
            hasPreviousField = true;
        }
        out.println();
    }

    private void writeCsvRow(PrintWriter out, User user) throws ReportException {
        try {
            boolean hasPreviousField = false;
            Map propMap = PropertyUtils.describe((Object)user);
            for (String propName : this.fields.keySet()) {
                Object propValue = propMap.get(propName);
                if (hasPreviousField) {
                    out.print(",");
                }
                if (propValue != null) {
                    out.print(this.escapeCell(propValue.toString()));
                }
                hasPreviousField = true;
            }
            out.println();
        }
        catch (IllegalAccessException e) {
            String emsg = "Unable to produce " + this.getName() + " report.";
            this.log.error(emsg, (Throwable)e);
            throw new ReportException(emsg, e);
        }
        catch (InvocationTargetException e) {
            String emsg = "Unable to produce " + this.getName() + " report.";
            this.log.error(emsg, (Throwable)e);
            throw new ReportException(emsg, e);
        }
        catch (NoSuchMethodException e) {
            String emsg = "Unable to produce " + this.getName() + " report.";
            this.log.error(emsg, (Throwable)e);
            throw new ReportException(emsg, e);
        }
    }

    private String escapeCell(String cell) {
        return "\"" + StringEscapeUtils.escapeJava((String)cell) + "\"";
    }
}

