/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.reports;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.redback.integration.reports.Report;
import org.codehaus.redback.integration.reports.ReportException;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="reportManager")
public class ReportManager
implements Initializable {
    private List<Report> availableReports;
    @Resource
    private PlexusContainer plexusContainer;
    private Map<String, Map<String, Report>> reportMap;

    public Report findReport(String id, String type) throws ReportException {
        if (StringUtils.isBlank((String)id)) {
            throw new ReportException("Unable to generate report from empty report id.");
        }
        if (StringUtils.isBlank((String)type)) {
            throw new ReportException("Unable to generate report from empty report type.");
        }
        Map<String, Report> typeMap = this.reportMap.get(id);
        if (typeMap == null) {
            throw new ReportException("Unable to find report id [" + id + "]");
        }
        Report requestedReport = typeMap.get(type);
        if (requestedReport == null) {
            throw new ReportException("Unable to find report id [" + id + "] type [" + type + "]");
        }
        return requestedReport;
    }

    public Map<String, Map<String, Report>> getReportMap() {
        return Collections.unmodifiableMap(this.reportMap);
    }

    public void initialize() throws InitializationException {
        try {
            this.availableReports = this.plexusContainer.lookupList(Report.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
        this.reportMap = new HashMap<String, Map<String, Report>>();
        for (Report report : this.availableReports) {
            Map<String, Report> typeMap = this.reportMap.get(report.getId());
            if (typeMap == null) {
                typeMap = new HashMap<String, Report>();
            }
            typeMap.put(report.getType(), report);
            this.reportMap.put(report.getId(), typeMap);
        }
    }
}

