/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.taglib.jsp;

import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.spring.PlexusToSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IfAnyAuthorizedTag
extends ConditionalTagSupport {
    private Logger log = LoggerFactory.getLogger(IfAnyAuthorizedTag.class);
    private String permissions;
    private String resource;

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected boolean condition() throws JspTagException {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        SecuritySession securitySession = (SecuritySession)this.pageContext.getSession().getAttribute("securitySession");
        try {
            SecuritySystem securitySystem = (SecuritySystem)applicationContext.getBean(PlexusToSpringUtils.buildSpringId((String)SecuritySystem.ROLE));
            if (securitySystem == null) {
                throw new JspTagException("unable to locate the security system");
            }
            StringTokenizer strtok = new StringTokenizer(this.permissions, ",");
            while (strtok.hasMoreTokens()) {
                String permission = strtok.nextToken().trim();
                if (!securitySystem.isAuthorized(securitySession, (Object)permission, (Object)this.resource)) continue;
                return true;
            }
        }
        catch (AuthorizationException ae) {
            throw new JspTagException("error with authorization", (Throwable)ae);
        }
        return false;
    }
}

