/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.integration.taglib.jsp;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.spring.PlexusToSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IfAuthorizedTag
extends ConditionalTagSupport {
    private Logger log = LoggerFactory.getLogger(IfAuthorizedTag.class);
    private String permission;
    private String resource;

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected boolean condition() throws JspTagException {
        boolean authzStatus;
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        Boolean authzStatusBool = (Boolean)this.pageContext.getAttribute("redbackCache" + this.permission + this.resource);
        if (authzStatusBool == null) {
            SecuritySession securitySession = (SecuritySession)this.pageContext.getSession().getAttribute("securitySession");
            try {
                SecuritySystem securitySystem = (SecuritySystem)applicationContext.getBean(PlexusToSpringUtils.buildSpringId((String)SecuritySystem.ROLE));
                if (securitySystem == null) {
                    throw new JspTagException("unable to locate security system");
                }
                authzStatus = securitySystem.isAuthorized(securitySession, (Object)this.permission, (Object)this.resource);
                this.pageContext.setAttribute("redbackCache" + this.permission + this.resource, (Object)authzStatus);
            }
            catch (AuthorizationException ae) {
                throw new JspTagException("error with authorization", (Throwable)ae);
            }
        } else {
            authzStatus = authzStatusBool;
        }
        this.pageContext.setAttribute("ifAuthorizedTag", (Object)authzStatus);
        return authzStatus;
    }
}

