/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.common.ldap;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.directory.Attributes;
import org.codehaus.plexus.redback.users.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUser
implements User {
    private String key;
    private String username;
    private String fullName;
    private String email;
    private String encodedPassword;
    private List<String> previousEncodedPasswords;
    private boolean locked = false;
    private boolean requiresPasswordChange = false;
    private boolean permanent = true;
    private boolean valid = true;
    private Date creationDate = null;
    private int failedLoginAttempts;
    private Date lastLoginDate = null;
    private Date lastPasswordChange = null;
    private String newPassword;
    private Attributes originalAttributes;

    public LdapUser(String username) {
        this.key = username;
        this.username = username;
        this.previousEncodedPasswords = new ArrayList<String>();
        this.failedLoginAttempts = 0;
    }

    public LdapUser(String username, String fullName, String email) {
        this(username);
        this.fullName = fullName;
        this.email = email;
    }

    public LdapUser() {
        this.previousEncodedPasswords = new ArrayList<String>();
        this.failedLoginAttempts = Integer.MIN_VALUE;
    }

    public void addPreviousEncodedPassword(String encodedPassword) {
        this.previousEncodedPasswords.add(encodedPassword);
    }

    public Date getAccountCreationDate() {
        return this.creationDate;
    }

    public int getCountFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public String getPassword() {
        return this.newPassword;
    }

    public List<String> getPreviousEncodedPasswords() {
        return this.previousEncodedPasswords;
    }

    public Object getPrincipal() {
        return this.key;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPasswordChangeRequired() {
        return this.requiresPasswordChange;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public boolean isValidated() {
        return this.valid;
    }

    public void setCountFailedLoginAttempts(int count) {
        this.failedLoginAttempts = count;
    }

    public void setEmail(String address) {
        this.email = address;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public void setAccountCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setLastLoginDate(Date date) {
        this.lastLoginDate = date;
    }

    public void setLastPasswordChange(Date passwordChangeDate) {
        this.lastPasswordChange = passwordChangeDate;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPassword(String rawPassword) {
        this.newPassword = rawPassword;
    }

    public void setPasswordChangeRequired(boolean changeRequired) {
        this.requiresPasswordChange = changeRequired;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public void setPreviousEncodedPasswords(List<String> encodedPasswordList) {
        this.previousEncodedPasswords = new ArrayList<String>(encodedPasswordList);
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public void setValidated(boolean valid) {
        this.valid = valid;
    }

    public Attributes getOriginalAttributes() {
        return this.originalAttributes;
    }

    public void setOriginalAttributes(Attributes originalAttributes) {
        this.originalAttributes = originalAttributes;
    }
}

