/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.common.ldap;

import java.util.Date;
import javax.annotation.Resource;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.common.ldap.LdapUser;
import org.codehaus.plexus.redback.common.ldap.LdapUtils;
import org.codehaus.plexus.redback.common.ldap.MappingException;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.common.ldap.UserUpdate;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="userMapper#ldap")
public class LdapUserMapper
implements UserMapper,
Initializable {
    String emailAttribute = "mail";
    String fullNameAttribute = "givenName";
    String passwordAttribute = "userPassword";
    String userIdAttribute = "cn";
    String userBaseDn;
    String userObjectClass = "inetOrgPerson";
    String userFilter;
    int maxResultCount = 0;
    @Resource(name="userConfiguration")
    private UserConfiguration userConf;

    public void initialize() throws InitializationException {
        this.emailAttribute = this.userConf.getString("ldap.config.mapper.attribute.email", this.emailAttribute);
        this.fullNameAttribute = this.userConf.getString("ldap.config.mapper.attribute.fullname", this.fullNameAttribute);
        this.passwordAttribute = this.userConf.getString("ldap.config.mapper.attribute.password", this.passwordAttribute);
        this.userIdAttribute = this.userConf.getString("ldap.config.mapper.attribute.user.id", this.userIdAttribute);
        this.userBaseDn = this.userConf.getConcatenatedList("ldap.config.mapper.attribute.user.base.dn", this.userConf.getConcatenatedList("ldap.config.base.dn", this.userBaseDn));
        this.userObjectClass = this.userConf.getString("ldap.config.mapper.attribute.user.object.class", this.userObjectClass);
        this.userFilter = this.userConf.getString("ldap.config.mapper.attribute.user.filter", this.userFilter);
        this.maxResultCount = this.userConf.getInt("ldap.config.max.result.count", this.maxResultCount);
    }

    public Attributes getCreationAttributes(User user, boolean encodePasswordIfChanged) throws MappingException {
        BasicAttributes userAttrs = new BasicAttributes();
        boolean passwordSet = false;
        if (!passwordSet && user.getEncodedPassword() != null) {
            userAttrs.put(this.getPasswordAttribute(), user.getEncodedPassword());
        }
        if (!StringUtils.isEmpty((String)user.getFullName())) {
            userAttrs.put(this.getUserFullNameAttribute(), user.getFullName());
        }
        if (!StringUtils.isEmpty((String)user.getEmail())) {
            userAttrs.put(this.getEmailAddressAttribute(), user.getEmail());
        }
        return userAttrs;
    }

    public String getEmailAddressAttribute() {
        return this.emailAttribute;
    }

    public String getUserFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public String[] getUserAttributeNames() {
        return new String[]{this.emailAttribute, this.fullNameAttribute, this.passwordAttribute, this.userIdAttribute};
    }

    public int getMaxResultCount() {
        return this.maxResultCount;
    }

    public UserUpdate getUpdate(LdapUser user) throws MappingException {
        BasicAttributes addAttrs = new BasicAttributes();
        BasicAttributes modAttrs = new BasicAttributes();
        if (!StringUtils.isEmpty((String)user.getFullName())) {
            if (user.getFullName() == null) {
                addAttrs.put(this.getUserFullNameAttribute(), user.getFullName());
            } else if (!user.getFullName().equals(user.getFullName())) {
                modAttrs.put(this.getUserFullNameAttribute(), user.getFullName());
            }
        }
        if (!StringUtils.isEmpty((String)user.getEmail())) {
            if (user.getEmail() == null) {
                addAttrs.put(this.getEmailAddressAttribute(), user.getEmail());
            } else if (!user.getEmail().equals(user.getEmail())) {
                modAttrs.put(this.getEmailAddressAttribute(), user.getEmail());
            }
        }
        return null;
    }

    public LdapUser getUser(Attributes attributes) throws MappingException {
        String userIdAttribute = this.getUserIdAttribute();
        String emailAddressAttribute = this.getEmailAddressAttribute();
        String nameAttribute = this.getUserFullNameAttribute();
        String passwordAttribute = this.getPasswordAttribute();
        String userId = LdapUtils.getAttributeValue(attributes, userIdAttribute, "username");
        LdapUser user = new LdapUser(userId);
        user.setOriginalAttributes(attributes);
        user.setEmail(LdapUtils.getAttributeValue(attributes, emailAddressAttribute, "email address"));
        user.setFullName(LdapUtils.getAttributeValue(attributes, nameAttribute, "name"));
        String encodedPassword = LdapUtils.getAttributeValueFromByteArray(attributes, passwordAttribute, "password");
        if (encodedPassword != null && encodedPassword.startsWith("{")) {
            encodedPassword = encodedPassword.substring(encodedPassword.indexOf("}") + 1);
        }
        user.setEncodedPassword(encodedPassword);
        user.setLastPasswordChange(new Date());
        return user;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    public void setMaxResultCount(int maxResultCount) {
        this.maxResultCount = maxResultCount;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public LdapUser newUserInstance(String username, String fullName, String email) {
        return new LdapUser(username, fullName, email);
    }

    public LdapUser newTemplateUserInstance() {
        return new LdapUser();
    }

    public String[] getReturningAttributes() {
        return new String[]{this.getUserIdAttribute(), this.getEmailAttribute(), this.getFullNameAttribute(), this.getPasswordAttribute()};
    }
}

