/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.common.ldap.connection;

import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnection;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionFactory;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="ldapConnectionFactory#configurable")
public class ConfigurableLdapConnectionFactory
implements LdapConnectionFactory,
Initializable {
    private String hostname;
    private int port;
    private boolean ssl;
    private String baseDn;
    private String contextFactory;
    private String bindDn;
    private String password;
    private String authenticationMethod;
    private Properties extraProperties;
    private LdapConnectionConfiguration configuration;
    @Resource(name="userConfiguration")
    private UserConfiguration userConf;

    public void initialize() throws InitializationException {
        try {
            this.configuration = new LdapConnectionConfiguration();
            this.configuration.setHostname(this.userConf.getString("ldap.config.hostname", this.hostname));
            this.configuration.setPort(this.userConf.getInt("ldap.config.port", this.port));
            this.configuration.setSsl(this.userConf.getBoolean("ldap.config.ssl", this.ssl));
            this.configuration.setBaseDn(this.userConf.getConcatenatedList("ldap.config.base.dn", this.baseDn));
            this.configuration.setContextFactory(this.userConf.getString("ldap.config.context.factory", this.contextFactory));
            this.configuration.setBindDn(this.userConf.getConcatenatedList("ldap.config.bind.dn", this.bindDn));
            this.configuration.setPassword(this.userConf.getString("ldap.config.password", this.password));
            this.configuration.setAuthenticationMethod(this.userConf.getString("ldap.config.authentication.method", this.authenticationMethod));
            this.configuration.setExtraProperties(this.extraProperties);
        }
        catch (InvalidNameException e) {
            throw new InitializationException("Error while initializing connection factory.", (Throwable)e);
        }
    }

    @Override
    public LdapConnection getConnection() throws LdapException {
        return new LdapConnection(this.configuration, null);
    }

    @Override
    public LdapConnection getConnection(Rdn subRdn) throws LdapException {
        return new LdapConnection(this.configuration, subRdn);
    }

    @Override
    public LdapConnection getConnection(String bindDn, String password) throws LdapException {
        return new LdapConnection(this.configuration, bindDn, password);
    }

    @Override
    public LdapName getBaseDnLdapName() throws LdapException {
        try {
            return new LdapName(this.baseDn);
        }
        catch (InvalidNameException e) {
            throw new LdapException("The base DN is not a valid name.", e);
        }
    }

    @Override
    public void addObjectFactory(Class<? extends ObjectFactory> objectFactoryClass) {
        this.configuration.getObjectFactories().add(objectFactoryClass);
    }

    @Override
    public void addStateFactory(Class<? extends StateFactory> stateFactoryClass) {
        this.configuration.getStateFactories().add(stateFactoryClass);
    }

    public String toString() {
        return "{ConfigurableLdapConnectionFactory: configuration: " + this.configuration + "}";
    }

    public LdapConnectionConfiguration getConfiguration() {
        return this.configuration;
    }
}

