/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.common.ldap.connection;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnection {
    private static LdapCtxFactory ctxFactory = new LdapCtxFactory();
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private LdapConnectionConfiguration config;
    private DirContext context;
    private List<Rdn> baseDnRdns;

    public LdapConnection(LdapConnectionConfiguration config, Rdn subRdn) throws LdapException {
        this.config = config;
        LdapName baseDn = new LdapName(config.getBaseDn().getRdns());
        if (subRdn != null) {
            baseDn.add(subRdn);
        }
        this.baseDnRdns = Collections.unmodifiableList(baseDn.getRdns());
        if (this.context != null) {
            throw new LdapException("Already connected.");
        }
        Hashtable<Object, Object> e = this.getEnvironment();
        try {
            this.context = (DirContext)ctxFactory.getInitialContext(e);
        }
        catch (NamingException ex) {
            throw new LdapException("Could not connect to the server.", ex);
        }
    }

    public LdapConnection(LdapConnectionConfiguration config, String bindDn, String password) throws LdapException {
        this.config = config;
        Hashtable<Object, Object> e = this.getEnvironment();
        e.put("java.naming.security.principal", bindDn);
        e.put("java.naming.security.credentials", password);
        try {
            this.context = (DirContext)ctxFactory.getInitialContext(e);
        }
        catch (NamingException ex) {
            throw new LdapException("Could not connect to the server.", ex);
        }
    }

    public Hashtable<Object, Object> getEnvironment() throws LdapException {
        Properties env = new Properties();
        env.putAll((Map<?, ?>)this.config.getExtraProperties());
        this.config.check();
        env.put("java.naming.factory.initial", this.config.getContextFactory());
        if (this.config.getHostname() != null) {
            String protocol;
            String string = protocol = this.config.isSsl() ? "ldaps" : "ldap";
            if (this.config.getPort() != 0) {
                env.put("java.naming.provider.url", protocol + "://" + this.config.getHostname() + ":" + this.config.getPort() + "/");
            } else {
                env.put("java.naming.provider.url", protocol + "://" + this.config.getHostname() + "/");
            }
        }
        if (this.config.getAuthenticationMethod() != null) {
            env.put("java.naming.security.authentication", this.config.getAuthenticationMethod());
        }
        if (this.config.getBindDn() != null) {
            env.put("java.naming.security.principal", this.config.getBindDn().toString());
        }
        if (this.config.getPassword() != null) {
            env.put("java.naming.security.credentials", this.config.getPassword());
        }
        String objectFactories = null;
        for (Class<?> objectFactoryClass : this.config.getObjectFactories()) {
            if (objectFactories == null) {
                objectFactories = objectFactoryClass.getName();
                continue;
            }
            objectFactories = objectFactories + ":" + objectFactoryClass.getName();
        }
        if (objectFactories != null) {
            env.setProperty("java.naming.factory.object", objectFactories);
        }
        String stateFactories = null;
        for (Class<?> stateFactoryClass : this.config.getStateFactories()) {
            if (stateFactories == null) {
                stateFactories = stateFactoryClass.getName();
                continue;
            }
            stateFactories = stateFactories + ":" + stateFactoryClass.getName();
        }
        if (stateFactories != null) {
            env.setProperty("java.naming.factory.state", stateFactories);
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException ex) {
            this.log.info("skip error closing ldap connection " + ex.getMessage());
        }
        finally {
            this.context = null;
        }
    }

    public LdapConnectionConfiguration getConfiguration() {
        return this.config;
    }

    public List<Rdn> getBaseDnRdns() {
        return this.baseDnRdns;
    }

    public DirContext getDirContext() {
        return this.context;
    }
}

