/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.common.ldap.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnectionConfiguration {
    private String hostname;
    private int port;
    private boolean ssl;
    private LdapName baseDn;
    private String contextFactory;
    private LdapName bindDn;
    private String password;
    private String authenticationMethod;
    private List<Class<?>> objectFactories;
    private List<Class<?>> stateFactories;
    private Properties extraProperties;

    public LdapConnectionConfiguration() {
    }

    public LdapConnectionConfiguration(String hostname, int port, LdapName baseDn, String contextFactory, LdapName bindDn, String password, String authenticationMethod, Properties extraProperties) throws LdapException {
        this.hostname = hostname;
        this.port = port;
        if (baseDn != null) {
            this.baseDn = new LdapName(baseDn.getRdns());
        }
        this.contextFactory = contextFactory;
        if (bindDn != null) {
            this.bindDn = new LdapName(bindDn.getRdns());
        }
        this.password = password;
        this.authenticationMethod = authenticationMethod;
        this.extraProperties = extraProperties;
        this.check();
    }

    public LdapConnectionConfiguration(String hostname, int port, String baseDn, String contextFactory, String bindDn, String password, String authenticationMethod, Properties extraProperties) throws InvalidNameException, LdapException {
        this.hostname = hostname;
        this.port = port;
        if (baseDn != null) {
            this.baseDn = new LdapName(baseDn);
        }
        if (bindDn != null) {
            this.bindDn = new LdapName(bindDn);
        }
        this.contextFactory = contextFactory;
        this.password = password;
        this.authenticationMethod = authenticationMethod;
        this.extraProperties = extraProperties;
        this.check();
    }

    public LdapConnectionConfiguration(String hostname, int port, LdapName baseDn, String contextFactory) throws LdapException {
        this.hostname = hostname;
        this.port = port;
        this.baseDn = baseDn;
        this.contextFactory = contextFactory;
        this.check();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public LdapName getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(LdapName baseDn) {
        this.baseDn = baseDn;
    }

    public void setBaseDn(String baseDn) throws InvalidNameException {
        if (baseDn != null) {
            this.baseDn = new LdapName(baseDn);
        }
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public LdapName getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(LdapName bindDn) {
        this.bindDn = bindDn;
    }

    public void setBindDn(String bindDn) throws InvalidNameException {
        if (bindDn != null) {
            this.bindDn = new LdapName(bindDn);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public List<Class<?>> getObjectFactories() {
        if (this.objectFactories == null) {
            this.objectFactories = new ArrayList();
        }
        return this.objectFactories;
    }

    public void setObjectFactories(List<Class<?>> objectFactories) {
        this.objectFactories = objectFactories;
    }

    public List<Class<?>> getStateFactories() {
        if (this.stateFactories == null) {
            this.stateFactories = new ArrayList();
        }
        return this.stateFactories;
    }

    public void setStateFactories(List<Class<?>> stateFactories) {
        this.stateFactories = stateFactories;
    }

    public Properties getExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public void check() throws LdapException {
        if (this.port < 0 || this.port > 65535) {
            throw new LdapException("The port must be between 1 and 65535.");
        }
        if (this.baseDn == null) {
            throw new LdapException("The base DN must be set.");
        }
        if (StringUtils.isEmpty((String)this.contextFactory)) {
            throw new LdapException("The context factory must be set.");
        }
        if (this.password != null && this.bindDn == null) {
            throw new LdapException("The password cant be set unless the bind dn is.");
        }
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
    }

    public String toString() {
        return "{LdapConnectionConfiguration: hostname: " + this.getHostname() + ", " + "port: " + this.getPort() + ", " + "ssl: " + this.isSsl() + ", " + "baseDn: " + this.getBaseDn() + ", " + "contextFactory: " + this.getContextFactory() + ", " + "bindDn: " + this.getBindDn() + ", " + "password: " + this.getPassword() + ", " + "authenticationMethod: " + this.getAuthenticationMethod() + ", " + "objectFactories: " + this.getObjectFactories() + ", " + "stateFactories: " + this.getStateFactories() + ", " + "extraProperties: " + new TreeMap<Object, Object>(this.extraProperties).toString() + "}";
    }
}

