/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys.cached;

import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.cache.Cache;
import org.codehaus.plexus.redback.keys.AbstractKeyManager;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="keyManager#cached")
public class CachedKeyManager
extends AbstractKeyManager
implements KeyManager {
    @Resource(name="keyManager#jdo")
    private KeyManager keyImpl;
    @Resource(name="cache#keys")
    private Cache keysCache;

    public AuthenticationKey addKey(AuthenticationKey key) {
        if (key != null) {
            this.keysCache.remove((Object)key.getKey());
        }
        return this.keyImpl.addKey(key);
    }

    public AuthenticationKey createKey(String principal, String purpose, int expirationMinutes) throws KeyManagerException {
        AuthenticationKey authkey = this.keyImpl.createKey(principal, purpose, expirationMinutes);
        this.keysCache.remove((Object)authkey.getKey());
        return authkey;
    }

    public void deleteKey(AuthenticationKey key) throws KeyManagerException {
        this.keysCache.remove((Object)key.getKey());
        this.keyImpl.deleteKey(key);
    }

    public void deleteKey(String key) throws KeyManagerException {
        this.keysCache.remove((Object)key);
        this.keyImpl.deleteKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseDatabase() {
        try {
            this.keyImpl.eraseDatabase();
        }
        finally {
            this.keysCache.clear();
        }
    }

    public AuthenticationKey findKey(String key) throws KeyNotFoundException, KeyManagerException {
        try {
            AuthenticationKey authkey = (AuthenticationKey)this.keysCache.get((Object)key);
            if (authkey != null) {
                this.assertNotExpired(authkey);
                return authkey;
            }
            authkey = this.keyImpl.findKey(key);
            this.keysCache.put((Object)key, (Object)authkey);
            return authkey;
        }
        catch (KeyNotFoundException knfe) {
            this.keysCache.remove((Object)key);
            throw knfe;
        }
    }

    public List<AuthenticationKey> getAllKeys() {
        this.log.debug("NOT CACHED - .getAllKeys()");
        return this.keyImpl.getAllKeys();
    }

    public String getId() {
        return "Cached Key Manager [" + this.keyImpl.getId() + "]";
    }
}

