/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys.jdo;

import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.jdo.PlexusObjectNotFoundException;
import org.codehaus.plexus.jdo.PlexusStoreException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.keys.AbstractKeyManager;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;
import org.codehaus.plexus.redback.keys.jdo.JdoAuthenticationKey;
import org.codehaus.plexus.redback.keys.jdo.RedbackKeyManagementJdoModelloMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.jpox.PersistenceManagerFactoryImpl;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="keyManager#jdo")
public class JdoKeyManager
extends AbstractKeyManager
implements Initializable {
    @Resource(name="jdoFactory#users")
    private JdoFactory jdoFactory;
    private PersistenceManagerFactory pmf;

    public AuthenticationKey createKey(String principal, String purpose, int expirationMinutes) throws KeyManagerException {
        JdoAuthenticationKey authkey = new JdoAuthenticationKey();
        authkey.setKey(super.generateUUID());
        authkey.setForPrincipal(principal);
        authkey.setPurpose(purpose);
        Calendar now = this.getNowGMT();
        authkey.setDateCreated(now.getTime());
        if (expirationMinutes >= 0) {
            Calendar expiration = this.getNowGMT();
            expiration.add(12, expirationMinutes);
            authkey.setDateExpires(expiration.getTime());
        }
        return this.addKey(authkey);
    }

    public AuthenticationKey addKey(AuthenticationKey key) {
        return (AuthenticationKey)PlexusJdoUtils.addObject((PersistenceManager)this.getPersistenceManager(), (Object)key);
    }

    public void eraseDatabase() {
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), JdoAuthenticationKey.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), RedbackKeyManagementJdoModelloMetadata.class);
    }

    public AuthenticationKey findKey(String key) throws KeyNotFoundException, KeyManagerException {
        if (StringUtils.isEmpty((String)key)) {
            throw new KeyNotFoundException("Empty key not found.");
        }
        try {
            JdoAuthenticationKey authkey = (JdoAuthenticationKey)PlexusJdoUtils.getObjectById((PersistenceManager)this.getPersistenceManager(), JdoAuthenticationKey.class, (String)key);
            if (authkey == null) {
                throw new KeyNotFoundException("Key [" + key + "] not found.");
            }
            this.assertNotExpired(authkey);
            return authkey;
        }
        catch (PlexusObjectNotFoundException e) {
            throw new KeyNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new KeyManagerException("Unable to get " + JdoAuthenticationKey.class.getName() + "', key '" + key + "' from jdo store.");
        }
    }

    public void deleteKey(AuthenticationKey authkey) throws KeyManagerException {
        PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)authkey);
    }

    public void deleteKey(String key) throws KeyManagerException {
        try {
            AuthenticationKey authkey = this.findKey(key);
            PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)authkey);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
    }

    public List<AuthenticationKey> getAllKeys() {
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(), JdoAuthenticationKey.class);
    }

    public void initialize() throws InitializationException {
        PersistenceManagerFactoryImpl jpoxpmf;
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
        if (this.pmf instanceof PersistenceManagerFactoryImpl && !StringUtils.equals((String)"JDK_DEFAULT_TIMEZONE", (String)(jpoxpmf = (PersistenceManagerFactoryImpl)this.pmf).getDateTimezone())) {
            throw new InitializationException("The JdoFactory property 'org.jpox.rdbms.dateTimezone' MUST BE Set to 'JDK_DEFAULT_TIMEZONE' in order for jpox and JdoKeyManager to operate correctly.");
        }
    }

    private PersistenceManager getPersistenceManager() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(5);
        return pm;
    }

    public String getId() {
        return "JDO Key Manager - " + ((Object)((Object)this)).getClass().getName();
    }

    public JdoFactory getJdoFactory() {
        return this.jdoFactory;
    }

    public void setJdoFactory(JdoFactory jdoFactory) {
        this.jdoFactory = jdoFactory;
    }
}

