/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys.jdo.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.plexus.redback.keys.jdo.AuthenticationKeyDatabase;
import org.codehaus.plexus.redback.keys.jdo.JdoAuthenticationKey;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class RedbackKeyManagementJdoStaxReader {
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private AuthenticationKeyDatabase parseAuthenticationKeyDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        AuthenticationKeyDatabase authenticationKeyDatabase = new AuthenticationKeyDatabase();
        authenticationKeyDatabase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("keys")) {
                if (parsed.contains("keys")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("keys");
                ArrayList keys = new ArrayList();
                authenticationKeyDatabase.setKeys(keys);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("key")) {
                        authenticationKeyDatabase.addKey(this.parseJdoAuthenticationKey("key", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return authenticationKeyDatabase;
    }

    private JdoAuthenticationKey parseJdoAuthenticationKey(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        JdoAuthenticationKey jdoAuthenticationKey = new JdoAuthenticationKey();
        jdoAuthenticationKey.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            String dateFormat;
            if (xmlStreamReader.getLocalName().equals("key")) {
                if (parsed.contains("key")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("key");
                jdoAuthenticationKey.setKey(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("forPrincipal")) {
                if (parsed.contains("forPrincipal")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("forPrincipal");
                jdoAuthenticationKey.setForPrincipal(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("purpose")) {
                if (parsed.contains("purpose")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("purpose");
                jdoAuthenticationKey.setPurpose(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("dateCreated")) {
                if (parsed.contains("dateCreated")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dateCreated");
                dateFormat = null;
                jdoAuthenticationKey.setDateCreated(this.getDateValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "dateCreated", dateFormat, xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("dateExpires")) {
                if (parsed.contains("dateExpires")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dateExpires");
                dateFormat = null;
                jdoAuthenticationKey.setDateExpires(this.getDateValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "dateExpires", dateFormat, xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return jdoAuthenticationKey;
    }

    public AuthenticationKeyDatabase read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        AuthenticationKeyDatabase value = this.parseAuthenticationKeyDatabase("authenticationKeyDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public AuthenticationKeyDatabase read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public AuthenticationKeyDatabase read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        AuthenticationKeyDatabase value = this.parseAuthenticationKeyDatabase("authenticationKeyDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public AuthenticationKeyDatabase read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(AuthenticationKeyDatabase value) {
    }
}

