/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys.jdo.io.stax;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.plexus.redback.keys.jdo.AuthenticationKeyDatabase;
import org.codehaus.plexus.redback.keys.jdo.JdoAuthenticationKey;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class RedbackKeyManagementJdoStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, AuthenticationKeyDatabase authenticationKeyDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(authenticationKeyDatabase.getModelEncoding(), "1.0");
        this.writeAuthenticationKeyDatabase(authenticationKeyDatabase, "authenticationKeyDatabase", (XMLStreamWriter)serializer);
        serializer.writeEndDocument();
    }

    private void writeAuthenticationKeyDatabase(AuthenticationKeyDatabase authenticationKeyDatabase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (authenticationKeyDatabase != null) {
            serializer.writeStartElement(tagName);
            if (authenticationKeyDatabase.getKeys() != null && authenticationKeyDatabase.getKeys().size() > 0) {
                serializer.writeStartElement("keys");
                for (JdoAuthenticationKey o : authenticationKeyDatabase.getKeys()) {
                    this.writeJdoAuthenticationKey(o, "key", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer) throws XMLStreamException {
        serializer.writeStartElement(dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.writeAttribute(attributeName, dom.getAttribute(attributeName));
        }
        Xpp3Dom[] children = dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeDom(children[i], serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeJdoAuthenticationKey(JdoAuthenticationKey jdoAuthenticationKey, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoAuthenticationKey != null) {
            serializer.writeStartElement(tagName);
            if (jdoAuthenticationKey.getKey() != null) {
                serializer.writeStartElement("key");
                serializer.writeCharacters(jdoAuthenticationKey.getKey());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getForPrincipal() != null) {
                serializer.writeStartElement("forPrincipal");
                serializer.writeCharacters(jdoAuthenticationKey.getForPrincipal());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getPurpose() != null) {
                serializer.writeStartElement("purpose");
                serializer.writeCharacters(jdoAuthenticationKey.getPurpose());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getDateCreated() != null) {
                serializer.writeStartElement("dateCreated");
                serializer.writeCharacters(Long.toString(jdoAuthenticationKey.getDateCreated().getTime()));
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getDateExpires() != null) {
                serializer.writeStartElement("dateExpires");
                serializer.writeCharacters(Long.toString(jdoAuthenticationKey.getDateExpires().getTime()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

